﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows.Primitives
{
    /// <summary>
    /// マーカーです。
    /// </summary>
    public sealed class PlotMarkerItem : ContentControl
    {
        /// <summary>
        /// マーカー位置を示す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty XProperty = DependencyProperty.Register(
            nameof(X),
            typeof(double),
            typeof(PlotMarkerItem),
            new PropertyMetadata(0.0));

        /// <summary>
        /// マーカーの表示名を示す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty DisplayNameProperty = DependencyProperty.Register(
            nameof(DisplayName),
            typeof(string),
            typeof(PlotMarkerItem),
            new PropertyMetadata(string.Empty));

        /// <summary>
        /// マーカーの結合の有無を示す依存プロパティキーです。
        /// </summary>
        private static readonly DependencyPropertyKey IsCombinedPropertyKey = DependencyProperty.RegisterReadOnly(
            nameof(IsCombined),
            typeof(bool),
            typeof(PlotMarkerItem),
            new PropertyMetadata(false));

        /// <summary>
        /// マーカーの結合の有無を示す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty IsCombinedProperty = IsCombinedPropertyKey.DependencyProperty;

        /// <summary>
        /// マーカーのストロークを示す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty StrokeProperty = DependencyProperty.Register(
            nameof(Stroke),
            typeof(Brush),
            typeof(PlotMarkerItem),
            new PropertyMetadata(Brushes.Orange));

        /// <summary>
        /// マーカーのストローク破線パターンを示す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty StrokeDashArrayProperty = DependencyProperty.Register(
            nameof(StrokeDashArray),
            typeof(DoubleCollection),
            typeof(PlotMarkerItem),
            new PropertyMetadata(null));

        /// <summary>
        /// マーカー位置を取得または設定します。
        /// </summary>
        public double X
        {
            get { return (double)this.GetValue(XProperty); }
            set { this.SetValue(XProperty, value); }
        }

        /// <summary>
        /// マーカーの表示名を取得または設定します。
        /// </summary>
        public string DisplayName
        {
            get { return (string)this.GetValue(DisplayNameProperty); }
            set { this.SetValue(DisplayNameProperty, value); }
        }

        /// <summary>
        /// マーカーの結合の有無を取得します。
        /// </summary>
        public bool IsCombined
        {
            get { return (bool)this.GetValue(IsCombinedProperty); }
            internal set { this.SetValue(IsCombinedPropertyKey, value); }
        }

        /// <summary>
        /// マーカーラインのストロークを取得または設定します。
        /// </summary>
        public Brush Stroke
        {
            get { return (Brush)this.GetValue(StrokeProperty); }
            set { this.SetValue(StrokeProperty, value); }
        }

        /// <summary>
        /// マーカーラインのストローク破線パターンを取得または設定します。
        /// </summary>
        public DoubleCollection StrokeDashArray
        {
            get { return (DoubleCollection)this.GetValue(StrokeDashArrayProperty); }
            set { this.SetValue(StrokeDashArrayProperty, value); }
        }
    }
}
