﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows.Primitives
{
    public class PlotGridItem : ContentControl
    {
        public static readonly DependencyProperty StrokeProperty =
            DependencyProperty.Register(
                nameof(Stroke),
                typeof(Brush),
                typeof(PlotGridItem),
                new FrameworkPropertyMetadata(Brushes.DimGray));

        static PlotGridItem()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(PlotGridItem),
                new FrameworkPropertyMetadata(typeof(PlotGridItem)));
        }

        public Brush Stroke
        {
            get { return (Brush)this.GetValue(StrokeProperty); }
            set { this.SetValue(StrokeProperty, value); }
        }
    }
}
