﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows;
using System.Windows.Input;

namespace NintendoWare.Spy.Windows.Interactivity
{
    public class MouseEventTrigger : System.Windows.Interactivity.EventTrigger
    {
        public static readonly DependencyProperty FiredOnProperty = DependencyProperty.Register(
            nameof(FiredOn),
            typeof(MouseEventTriggerFiredOn),
            typeof(MouseEventTrigger),
            new PropertyMetadata(MouseEventTriggerFiredOn.MouseDown, OnFiredOnChanged));

        public static readonly DependencyProperty MouseButtonProperty = DependencyProperty.Register(
            nameof(MouseButton),
            typeof(MouseButton),
            typeof(MouseEventTrigger),
            new PropertyMetadata(MouseButton.Left));

        public static readonly DependencyProperty IsHandledSetProperty = DependencyProperty.Register(
            nameof(IsHandledSet),
            typeof(bool),
            typeof(MouseEventTrigger),
            new PropertyMetadata(false));

        //-----------------------------------------------------------------

        public MouseEventTriggerFiredOn FiredOn
        {
            get { return (MouseEventTriggerFiredOn)GetValue(FiredOnProperty); }
            set { SetValue(FiredOnProperty, value); }
        }

        public MouseButton MouseButton
        {
            get { return (MouseButton)GetValue(MouseButtonProperty); }
            set { SetValue(MouseButtonProperty, value); }
        }

        public bool IsHandledSet
        {
            get { return (bool)GetValue(IsHandledSetProperty); }
            set { SetValue(IsHandledSetProperty, value); }
        }

        //-----------------------------------------------------------------

        protected override void OnAttached()
        {
            this.UpdateEventName();
            base.OnAttached();
        }

        protected override void OnEvent(EventArgs eventArgs)
        {
            var mouseEventArgs = (MouseButtonEventArgs)eventArgs;

            if (mouseEventArgs.ChangedButton != this.MouseButton)
            {
                return;
            }

            base.OnEvent(eventArgs);

            if (this.IsHandledSet)
            {
                mouseEventArgs.Handled = true;
            }
        }

        private void UpdateEventName()
        {
            switch (this.FiredOn)
            {
                case MouseEventTriggerFiredOn.MouseDown:
                    this.EventName = "MouseDown";
                    break;

                case MouseEventTriggerFiredOn.MouseUp:
                    this.EventName = "MouseUp";
                    break;

                case MouseEventTriggerFiredOn.PreviewMouseDown:
                    this.EventName = "PreviewMouseDown";
                    break;

                case MouseEventTriggerFiredOn.PreviewMouseUp:
                    this.EventName = "PreviewMouseUp";
                    break;

                case MouseEventTriggerFiredOn.MouseClick:
                    this.EventName = "MouseClick";
                    break;

                case MouseEventTriggerFiredOn.MouseDoubleClick:
                    this.EventName = "MouseDoubleClick";
                    break;
            }
        }

        private static void OnFiredOnChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            var target = (MouseEventTrigger)sender;
            target.UpdateEventName();
        }
    }
}
