﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Windows.Controls;

namespace NintendoWare.Spy.Framework.Windows
{
    /// <summary>
    /// パネルのプレゼンターです。
    /// </summary>
    public abstract class PanelPresenter : Presenter
    {
        private Control _content;

        //-----------------------------------------------------------------

        /// <summary>
        /// UI 要素 を取得します。
        /// </summary>
        public Control Content
        {
            get { return _content; }
            private set { this.SetPropertyValue(ref _content, value); }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// UI 要素を生成します。
        /// </summary>
        /// <returns>生成した UI 要素 を返します。</returns>
        protected abstract Control CreateContent();

        protected override void OnInitialize()
        {
            Ensure.Operation.Null(_content);

            this.Content = this.CreateContent();
        }

        protected override void OnUninitialize()
        {
            this.Content = null;
        }
    }
}
