﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Settings;
using System;
using System.Collections.Generic;
using System.IO;

namespace NintendoWare.Spy.Framework.Settings
{
    // HACK : ★解決すべき課題あり
    //        - Applied イベントによる全設定の一括反映は良いか？
    //        - SettingItem.Value の型を IDeepClonable に変更して、辞書内の値を直接編集できないようにすべきか。
    //          SettingItem.Value のプロパティ監視は面倒なのでやめたい。
    //        - ApplySettingsEventArgs に Item.Key を含めるとよさそう。

    /// <summary>
    /// アプリケーション設定を提供するサービスです。
    /// </summary>
    public sealed class SettingsService
    {
        private readonly Dictionary<string, SettingItem> _items = new Dictionary<string, SettingItem>();

        //-----------------------------------------------------------------

        public event EventHandler Applied;

        //-----------------------------------------------------------------

        public IDictionary<string, SettingItem> Items
        {
            get { return _items; }
        }

        //-----------------------------------------------------------------

        public void Load(Stream stream)
        {
            var root = SettingsRoot.Load(stream);

            if (root != null)
            {
                foreach (var item in root.Items)
                {
                    this.Items[item.Key] = item;
                }
            }
        }

        public void Save(Stream stream)
        {
            SettingsRoot root = new SettingsRoot();

            foreach (var item in this.Items.Values)
            {
                root.Items.Add(item);
            }

            SettingsRoot.Save(stream, root);
        }

        public void Clear()
        {
            _items.Clear();
        }

        public void Apply()
        {
            this.Applied?.Invoke(this, EventArgs.Empty);
        }

        /// <summary>
        /// 設定値を取得します。
        /// </summary>
        /// <returns>設定値を返します。</returns>
        public TValue GetSettingItemValue<TValue>(string key)
            where TValue : new()
        {
            Ensure.Argument.StringIsNotNullOrEmpty(key);

            if (!this.Items.TryGetValue(key, out SettingItem item))
            {
                item = new SettingItem()
                {
                    Key = key,
                    Value = new TValue(),
                };

                this.Items.Add(item.Key, item);
            }

            if (item.Value is TValue)
            {
                return (TValue)item.Value;
            }

            // TODO : TypeConverterAttribute を見て型変換を試みる
            throw new InvalidOperationException();
        }
    }
}
