﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.Spy.Framework
{
    /// <summary>
    /// フレームワーク設定を保持します。
    /// </summary>
    public interface IApplicationFrameworkSettings
    {
        /// <summary>
        /// ルートサービスプロバイダの生成メソッドを取得します。
        /// </summary>
        Func<IServiceProvider> CreateRootServiceProvider { get; }

        /// <summary>
        /// アプリケーションプレゼンターの生成メソッドを取得します。
        /// </summary>
        Func<ApplicationPresenter> CreateApplicationPresenterFunc { get; }
    }
}
