﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;

namespace NintendoWare.Spy.Foundation
{
    /// <summary>
    /// アプリケーション情報を取得します。
    /// </summary>
    public interface IApplicationInfo
    {
        /// <summary>
        /// アプリケーション名を取得します。
        /// </summary>
        string Name { get; }

        /// <summary>
        /// バージョン情報を取得します。
        /// </summary>
        Version Version { get; }

        /// <summary>
        /// RC, RTM 等、バージョンのフェイズを取得します。
        /// </summary>
        string VersionPhase { get; }

        /// <summary>
        /// 著作権情報を取得します。
        /// </summary>
        string Copyright { get; }

        /// <summary>
        /// アプリケーションアイコンを取得します。
        /// </summary>
        Icon Icon { get; }
    }
}
