﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.InGameEditing.Communication;
using NintendoWare.Spy.Foundation.Platform;
using System;
using System.Text.RegularExpressions;

namespace NintendoWare.Spy.Foundation.Communications.Htcs
{
    public sealed class HostIOHtcsPluginWin : HostIOPlugin
    {
        private static readonly Lazy<HostIOHtcs> FieldInstance = new Lazy<HostIOHtcs>(() => new HostIOHtcs(IsTargetPort));

        private static readonly Regex FieldRegexPeerType = new Regex(@"-Windows$");

        public override string Platform
        {
            get { return PlatformWin.Name; }
        }

        //-----------------------------------------------------------------

        protected override IComEndPoint GetHostIOImpl()
        {
            return FieldInstance.Value;
        }

        /// <summary>
        /// 接続対象であるか判定します。
        /// プラットフォームが Windows の場合に接続対象とします。
        /// スペックは問いません。
        /// </summary>
        /// <param name="targetInfo"></param>
        /// <param name="portInfo"></param>
        /// <returns></returns>
        private static bool IsTargetPort(TargetInfo targetInfo, PortInfo portInfo)
        {
            bool isTarget = FieldRegexPeerType.IsMatch(targetInfo.PeerType);
            return isTarget;
        }
    }
}
