﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.Spy.Foundation.Commands
{
    /// <summary>
    /// コマンド引数であることを示します。
    /// </summary>
    public abstract class CommandArgs : IDeepClonable
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        protected CommandArgs()
        {
        }

        object IDeepClonable.DeepClone()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 指定のオブジェクトにディープクローンします。
        /// </summary>
        /// <param name="to"></param>
        /// <returns>引数 <paramref name="to"/> を返します。</returns>
        protected object DeepCloneTo(CommandArgs to)
        {
            return to;
        }
    }
}
