﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.ComponentModel;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.Spy.Windows
{
    public class MeterPerformanceNodeData : ObservableObject
    {
        private readonly ObservableKeyedList<string, MeterPerformanceData> _performanceDatas = new ObservableKeyedList<string, MeterPerformanceData>(item => item.Name);

        public MeterPerformanceNodeData(SpyService spyService, string name)
        {
            this.SpyService = spyService;
            this.Name = name;
        }

        public string Name
        {
            get;
            private set;
        }

        public SpyService SpyService
        {
            get;
            private set;
        }

        public MeterPerformanceData CreatePerformanceData(PlotSpyModel.PlotFloat item, string dataName)
        {
            MeterPerformanceData itemData = null;

            if (_performanceDatas.ContainsKey(dataName) == true)
            {
                itemData = _performanceDatas.GetItem(dataName);
                CollectionChangedObservation.RemoveObservers(itemData.Values);
            }
            else
            {
                itemData = new MeterPerformanceData(this.SpyService, dataName, item.Color);
                _performanceDatas.Add(itemData);
            }

            CollectionChangedObservation.GetObserver(itemData.Values, item.Values).AddHandlerForAddItems(
                (sender, e) => AddItems(itemData, dataName, e.Items.OfType<PlotSpyModel.PlotFloatValue>()));

            AddItems(itemData, dataName, item.Values);

            return itemData;
        }

        protected override void DisposeManagedInstance()
        {
            base.DisposeManagedInstance();

            foreach (var itemData in _performanceDatas)
            {
                CollectionChangedObservation.RemoveObservers(itemData.Values);
            }
            _performanceDatas.Clear();
        }

        private void AddItems(MeterPerformanceData itemData, string dataName, IEnumerable<PlotSpyModel.PlotFloatValue> items)
        {
            items.ForEach(d => itemData.Values.Add(d));
        }
    }
}
