﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;

namespace NintendoWare.Spy.Windows
{
    public class MainWindowStatusLoadingViewModel : ObservableObject
    {
        private bool _visible = true;
        private int _progress;

        public MainWindowStatusLoadingViewModel(MainWindowViewModel mainWindow)
        {
            this.MainWindow = mainWindow;
        }

        public MainWindowViewModel MainWindow { get; }

        public bool Visible
        {
            get { return _visible; }
            set { this.SetPropertyValue(ref _visible, value); }
        }

        public int Progress
        {
            get { return _progress; }
            set { this.SetPropertyValue(ref _progress, value); }
        }
    }
}
