﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;

namespace NintendoWare.Spy.Windows
{
    public sealed class ApiCallLineViewModel : ObservableObject
    {
        private bool _isCurrent = false;
        private bool _isAboveLineVisible = false;
        private bool _isBelowLineVisible = false;
        private bool _isFirstAtTime = false;

        private SpyTime _time = SpyTime.InvalidValue;
        private string _text = string.Empty;
#if false // TODO: NW-104
        private readonly string _modelText = string.Empty;
#endif

        //-----------------------------------------------------------------

        public ApiCallLineViewModel()
        {
        }

        public ApiCallLineViewModel(ApiCallSpyModel.LogLine model)
        {
#if false // TODO: NW-104
            _modelText = model.Text;
#endif
            this.Text = model.Text;
            this.Time = new SpyTime(model.Timestamp, model.BelongingFrame);
        }

        //-----------------------------------------------------------------

        public string Text
        {
            get { return _text; }
            set { this.SetPropertyValue(ref _text, value); }
        }

        public SpyTime Time
        {
            get { return _time; }
            set { this.SetPropertyValue(ref _time, value); }
        }

        public bool IsCurrent
        {
            get { return _isCurrent; }
            set { this.SetPropertyValue(ref _isCurrent, value); }
        }

        public bool IsFirstAtTime
        {
            get { return _isFirstAtTime; }
            set { this.SetPropertyValue(ref _isFirstAtTime, value); }
        }

        public bool IsAboveLineVisible
        {
            get { return _isAboveLineVisible; }
            set { this.SetPropertyValue(ref _isAboveLineVisible, value); }
        }

        public bool IsBelowLineVisible
        {
            get { return _isBelowLineVisible; }
            set { this.SetPropertyValue(ref _isBelowLineVisible, value); }
        }

        //-----------------------------------------------------------------

#if false // TODO: NW-104
        public void ResolveLabel(SoundDataInfoSpyModel soundDataInfoSpyModel)
        {
            if (soundDataInfoSpyModel == null)
            {
                return;
            }

            try
            {
                var match = Regex.Match(_modelText, @"\[ID:([\dA-Za-z]{8})\]");

                if (match.Groups.Count != 2)
                {
                    return;
                }

                var id = Convert.ToUInt32(match.Groups[1].Value, 16);
                var label = soundDataInfoSpyModel.GetLabel(id);

                if (string.IsNullOrEmpty(label))
                {
                    return;
                }

                this.Text = _modelText.Insert(
                    match.Groups[0].Index + match.Groups[0].Length,
                    string.Format("({0})", label)
                    );
            }
            catch
            {
                return;
            }
        }
#endif
    }
}
