﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;

namespace NintendoWare.Spy.Settings
{
    public sealed class WindowsSettings : ObservableObject
    {
        private MainWindowSettings _mainWindowSettings = new MainWindowSettings();

        //-----------------------------------------------------------------

        public bool IsMouseTiltEnabled { get; set; } = true;

        public MainWindowSettings MainWindowSettings
        {
            get { return _mainWindowSettings; }
            set { this.SetPropertyValue(ref _mainWindowSettings, value); }
        }
    }
}
