﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.Spy.Settings
{
    /// <summary>
    /// アイテムを格納するコンテナのXML要素クラスです。
    /// </summary>
    [System.Xml.Serialization.XmlRoot("SettingsRoot")]
    public sealed class TeamSettingsRoot
    {
        public TeamSettingsRoot()
        {
            this.Items = new List<TeamSettingItem>();
        }

        /// <summary>
        /// アイテムを取得または設定します。
        /// </summary>
        [System.Xml.Serialization.XmlElement("SettingItem")]
        public List<TeamSettingItem> Items
        {
            get; set;
        }

        /// <summary>
        /// バージョンを取得または設定します。
        /// </summary>
        [System.Xml.Serialization.XmlAttribute("Version")]
        public string Version
        {
            get; set;
        }
    }
}
