﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;

namespace NintendoWare.Spy.Settings
{
    public sealed class MainWindowSettings : ObservableObject
    {
        private WindowPosition _position = new WindowPosition()
        {
            Width = 1200,
            Height = 900,
        };

        private string _panelLayouts = string.Empty;

        //-----------------------------------------------------------------

        public WindowPosition Position
        {
            get { return _position; }
            set { this.SetPropertyValue(ref _position, value); }
        }

        public string PanelLayouts
        {
            get { return _panelLayouts; }
            set { this.SetPropertyValue(ref _panelLayouts, value); }
        }
    }
}
