﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation;
using NintendoWare.Spy.Foundation.Commands;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// Spy サービスコマンドの引数。
    /// </summary>
    public class SpyServiceCommandArgs : CommandArgs, IDeepClonable
    {
        public SpyService SpyService { get; set; }

        public SpyServiceCommandArgs()
        {
        }

        object IDeepClonable.DeepClone()
        {
            return this.DeepCloneTo(new SpyServiceCommandArgs());
        }

        protected object DeepCloneTo(SpyServiceCommandArgs to)
        {
            base.DeepCloneTo(to);

            to.SpyService = this.SpyService;

            return to;
        }
    }
}
