﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation.Commands;
using NintendoWare.Spy.Resources;

namespace NintendoWare.Spy.Commands
{
    public class SpyCommands
    {
        /// <summary>
        /// ターゲットに接続コマンド。
        /// </summary>
        public static readonly Command Connect = new Command(
            "Spy.Connect",
            CommandLabels.SpyConnect,
            null,
            typeof(ConnectCommandArgs));

        /// <summary>
        /// ターゲットから切断コマンド。
        /// </summary>
        public static readonly Command Disconnect = new Command(
            "Spy.Disconnect",
            CommandLabels.SpyDisconnect,
            null,
            typeof(SpyServiceCommandArgs));

        /// <summary>
        /// すべて記録コマンド。
        /// </summary>
        public static readonly Command RecordAllFiles = new Command(
            "Spy.RecordAllFiles",
            CommandLabels.SpyRecordAllFiles,
            null,
            typeof(SpyServiceCommandArgs));

        /// <summary>
        /// Spy データ ID フラグの更新コマンド。
        /// </summary>
        public static readonly Command UpdateSpyDataIDFlags = new Command(
            "Spy.UpdateSpyDataIDFlags",
            string.Empty);    // 非公開
    }
}
