﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.SpySample.Windows.Controls
{
    public class Plot2DViewItem : ContentControl
    {
        private static readonly Brush DefaultFill = Brushes.Red;

        public static readonly DependencyProperty FillProperty =
            DependencyProperty.Register(
                nameof(Fill),
                typeof(Brush),
                typeof(Plot2DViewItem),
                new FrameworkPropertyMetadata(
                    DefaultFill,
                    null,
                    (d, e) => Self(d).CoerceFill(e)));

        public static readonly DependencyProperty XProperty =
            DependencyProperty.Register(
                nameof(X),
                typeof(double),
                typeof(Plot2DViewItem),
                new FrameworkPropertyMetadata(
                    0.0,
                    (d, e) => Self(d).UpdateCanvasLeft((double)e.NewValue)));

        public static readonly DependencyProperty YProperty =
            DependencyProperty.Register(
                nameof(Y),
                typeof(double),
                typeof(Plot2DViewItem),
                new FrameworkPropertyMetadata(
                    0.0,
                    (d, e) => Self(d).UpdateCanvasTop((double)e.NewValue)));

        private Plot2DView owner;

        static Plot2DViewItem()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(Plot2DViewItem),
                new FrameworkPropertyMetadata(typeof(Plot2DViewItem)));
        }

        public Plot2DViewItem()
        {
        }

        public Brush Fill
        {
            get { return (Brush)this.GetValue(FillProperty); }
            set { this.SetValue(FillProperty, value); }
        }

        public double X
        {
            get { return (double)this.GetValue(XProperty); }
            set { this.SetValue(XProperty, value); }
        }

        public double Y
        {
            get { return (double)this.GetValue(YProperty); }
            set { this.SetValue(YProperty, value); }
        }

        internal void SetOwner(Plot2DView owner)
        {
            this.owner = owner;
        }

        protected override void OnRenderSizeChanged(SizeChangedInfo sizeInfo)
        {
            base.OnRenderSizeChanged(sizeInfo);

            if (this.owner != null)
            {
                this.owner.UpdateItemCanvasLeft(this, this.X);
                this.owner.UpdateItemCanvasTop(this, this.Y);
            }
        }

        private void UpdateCanvasLeft(double v)
        {
            if (this.owner != null)
            {
                this.owner.UpdateItemCanvasLeft(this, v);
            }
        }

        private void UpdateCanvasTop(double v)
        {
            if (this.owner != null)
            {
                this.owner.UpdateItemCanvasTop(this, v);
            }
        }

        private object CoerceFill(object e)
        {
            if (e is Brush)
            {
                return e;
            }
            else
            {
                return DefaultFill;
            }
        }

        private static Plot2DViewItem Self(object obj)
        {
            return (Plot2DViewItem)obj;
        }
    }
}
