﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Windows;
using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Interactivity;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class GroupItemBehavior : Behavior<Decorator>
    {
        public static readonly DependencyProperty AutoVisibilityProperty = DependencyProperty.Register(
            nameof(AutoVisibility),
            typeof(bool),
            typeof(GroupItemBehavior));

        /// <summary>
        /// アイテムがすべて Collapsed のときは、グループ自身も Collapsed にします。
        /// </summary>
        public bool AutoVisibility
        {
            get { return (bool)GetValue(AutoVisibilityProperty); }
            set { SetValue(AutoVisibilityProperty, value); }
        }

        public GroupItemBehavior()
        {
        }

        protected override void OnAttached()
        {
            base.OnAttached();

            this.AssociatedObject.LayoutUpdated += HandleLayoutUpdated;
        }

        protected override void OnDetaching()
        {
            this.AssociatedObject.LayoutUpdated -= HandleLayoutUpdated;

            base.OnDetaching();
        }

        private void HandleLayoutUpdated(object sender, EventArgs e)
        {
            if (this.AutoVisibility)
            {
                var itemsPresenter = VisualTreeUtility.FindFirstDescendant<ItemsPresenter>(this.AssociatedObject);
                if (itemsPresenter != null)
                {
                    foreach (var child in VisualTreeUtility.EnumerateChildren(itemsPresenter))
                    {
                        if (!(child is UIElement) || ((UIElement)child).Visibility != Visibility.Collapsed)
                        {
                            foreach (var grandChild in VisualTreeUtility.EnumerateChildren(child))
                            {
                                if (CheckVisibility(grandChild) != Visibility.Collapsed)
                                {
                                    this.AssociatedObject.Visibility = Visibility.Visible;
                                    return;
                                }
                            }
                        }
                    }

                    this.AssociatedObject.Visibility = Visibility.Collapsed;
                }
            }
        }

        private Visibility CheckVisibility(DependencyObject d)
        {
            if (d is UIElement)
            {
                var elem = (UIElement)d;

                if (elem.Visibility == Visibility.Collapsed)
                {
                    return Visibility.Collapsed;
                }
                else
                {
                    return Visibility.Visible;
                }
            }
            else
            {
                return Visibility.Visible;
            }
        }
    }
}
