﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.AudioToolKit.Xml
{
    using Nintendo.AudioToolkit.DataModels;
    using Nintendo.Foundation.Contracts;
    using System.Collections.Generic;
    using System.Linq;
    using System.Xml.Serialization;

    /// <summary>
    /// ウェーブサウンドリソースデータの XML モデルです。
    /// </summary>
    [XmlRoot("WaveSoundResource")]
    public class WaveSoundResourceDataXml
    {
        public const string XmlNamespacePrefix = "atk";

        private List<WaveSoundTrackResourceDataXml> trackResources = new List<WaveSoundTrackResourceDataXml>();

        /// <summary>
        /// 名前を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public string Name { get; set; }

        /// <summary>
        /// トラックリストを取得します。
        /// </summary>
        [XmlArray("WaveSoundTrackResources")]
        [XmlArrayItem("WaveSoundTrackResource", typeof(WaveSoundTrackResourceDataXml))]
        public List<WaveSoundTrackResourceDataXml> TrackResources
        {
            get { return this.trackResources; }
        }

        /// <summary>
        /// データモデルから XML モデルを作成します。
        /// </summary>
        /// <returns>XML モデルを返します。</returns>
        public static WaveSoundResourceDataXml FromDataModel(WaveSoundResourceData dataModel)
        {
            Ensure.Argument.NotNull(dataModel);

            var result = new WaveSoundResourceDataXml()
            {
                Name = dataModel.Name,
            };

            dataModel.TrackResources.ForEach(
                track => result.TrackResources.Add(WaveSoundTrackResourceDataXml.FromDataModel(track)));

            return result;
        }

        /// <summary>
        /// データモデルに変換します。
        /// </summary>
        /// <returns>変換後のデータモデルを返します。</returns>
        public WaveSoundResourceData ToDataModel()
        {
            var result = new WaveSoundResourceData()
            {
                Name = this.Name,
            };

            this.TrackResources.ForEach(clip => result.TrackResources.Add(clip.ToDataModel()));
            return result;
        }
    }
}
