﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Xml;
using System.Globalization;

namespace Nintendo.AudioToolkit.Windows.Controls
{
    public class TimelineControlItem : ContentControl
    {
        public TimelineControlItem()
        {
        }

        public bool IsSelected
        {
            get { return (bool)base.GetValue(IsSelectedProperty); }
            set { base.SetValue(IsSelectedProperty, value); }
        }

        public static readonly DependencyProperty IsSelectedProperty =
            DependencyProperty.Register("IsSelected", typeof(bool), typeof(TimelineControlItem),
            new FrameworkPropertyMetadata(false));

        public double OffsetX
        {
            get { return (double)GetValue(OffsetXProperty); }
            set { SetValue(OffsetXProperty, value); }
        }

        public static readonly DependencyProperty OffsetXProperty =
            DependencyProperty.Register("OffsetX", typeof(double), typeof(TimelineControlItem),
            new FrameworkPropertyMetadata(0.0));

        public double? MaximumWidth
        {
            get { return (double?)GetValue(MaximumWidthProperty); }
            set { SetValue(MaximumWidthProperty, value); }
        }

        public static readonly DependencyProperty MaximumWidthProperty =
            DependencyProperty.Register("MaximumWidth", typeof(double?), typeof(TimelineControlItem),
            new FrameworkPropertyMetadata(double.NaN));

        internal Thumb LeftThumb
        {
            get;
            private set;
        }

        internal Thumb RightThumb
        {
            get;
            private set;
        }

        public override void OnApplyTemplate()
        {
            base.OnApplyTemplate();

            this.LeftThumb = (Thumb)this.Template.FindName("ResizeThumbLeft", this);
            this.RightThumb = (Thumb)this.Template.FindName("ResizeThumbRight", this);
        }
    }
}
