﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace Nintendo.AudioToolkit.Extensions
{
    using Nintendo.AudioToolkit.Operations;

    internal static class IOperationExecutorExtensions
    {
        public static void SetParameter<T>(this IOperationExecutor executor, T oldValue, T newValue, Action<T> action)
        {
            executor.ExecuteOperation(
                delegate ()
                {
                    action(newValue);
                },
                delegate ()
                {
                    action(oldValue);
                });
        }

        public static void AddItem<TItem>(this IOperationExecutor executor, IList<TItem> collection, TItem item) where TItem : class
        {
            executor.ExecuteOperation(
                delegate ()
                {
                    collection.Add(item);
                },
                delegate ()
                {
                    collection.Remove(item);
                });
        }

        public static void RemoveItem<TItem>(this IOperationExecutor executor, IList<TItem> collection, TItem item) where TItem : class
        {
            var index = collection.IndexOf(item);

            executor.ExecuteOperation(
                delegate ()
                {
                    collection.RemoveAt(index);
                },
                delegate ()
                {
                    collection.Insert(index, item);
                });
        }
    }
}
