﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <nw/ut.h>
#include <resources/GlobalResources.h>
#include <resources/GlobalResourceProvider.h>
#include <models/PreviewSoundArchive.h>
#include <models/PreviewEffectManager.h>

namespace nw {
namespace snd {

GlobalResourceProvider::GlobalResourceProvider() :
m_Allocator(NULL),
#if defined(NW_PLATFORM_CAFE)
m_FsClient(NULL),
m_FsCmdBlock(NULL),
m_HfioVolume(NULL),
#endif
m_pPreviewSoundArchive(NULL),
m_pPreviewEffectManager(NULL),
m_pSoundEditSession(NULL)
{
}

void* GlobalResourceProvider::GetResource(const char* pPath) const
{
    NW_NULL_ASSERT(pPath);

    void* result = NULL;
    bool isResouceFound = TryGetResource(pPath, &result);

    NW_ASSERTMSG(isResouceFound, "[GlobalResourceProvider] resource not found. : '%s'", pPath);
    return result;
}

bool GlobalResourceProvider::TryGetResource(const char* pPath, void** pResource) const
{
    NW_NULL_ASSERT(pPath);

    if(pResource != NULL)
    {
        *pResource = NULL;
    }

    static u32 categoryPathLength = strlen(GlobalResources::CategoryPath);
    if(strncmp(pPath, GlobalResources::CategoryPath, categoryPathLength) != 0)
    {
        return false;
    }

    const char* pLocalPath = pPath + categoryPathLength;

    if(nw::ut::stricmp(pLocalPath, GlobalResources::Allocator) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_Allocator);
        return true;
    }

#if defined(NW_PLATFORM_CAFE)
    if(nw::ut::stricmp(pLocalPath, GlobalResources::FsClient) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_FsClient);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::FsCmdBlock) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_FsCmdBlock);
        return true;
    }
#endif

    if(nw::ut::stricmp(pLocalPath, GlobalResources::PreviewSoundArchive) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_pPreviewSoundArchive);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::PreviewEffectManager) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_pPreviewEffectManager);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::PreviewEffectManagerDrc) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_pPreviewEffectManagerDrc);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::SoundEditSession) == 0)
    {
        *pResource = reinterpret_cast<void*>(m_pSoundEditSession);
        return true;
    }

    return false;
}

const void* GlobalResourceProvider::GetConstResource(const char* pPath) const
{
    NW_NULL_ASSERT(pPath);

    const void* result = NULL;
    bool isResouceFound = TryGetConstResource(pPath, &result);

    NW_ASSERTMSG(isResouceFound, "[GlobalResourceProvider] resource not found. : '%s'", pPath);
    return result;
}

bool GlobalResourceProvider::TryGetConstResource(const char* pPath, const void** pResource) const
{
    NW_NULL_ASSERT(pPath);

    if(pResource != NULL)
    {
        *pResource = NULL;
    }

    static u32 categoryPathLength = strlen(GlobalResources::CategoryPath);
    if(strncmp(pPath, GlobalResources::CategoryPath, categoryPathLength) != 0)
    {
        return false;
    }

    const char* pLocalPath = pPath + categoryPathLength;

#if defined(NW_PLATFORM_CAFE)
    if(nw::ut::stricmp(pLocalPath, GlobalResources::FsClient) == 0)
    {
        *pResource = reinterpret_cast<const void*>(m_FsClient);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::FsCmdBlock) == 0)
    {
        *pResource = reinterpret_cast<const void*>(m_FsCmdBlock);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::HfioVolume) == 0)
    {
        *pResource = m_HfioVolume;
        return true;
    }
#endif

    if(nw::ut::stricmp(pLocalPath, GlobalResources::PreviewSoundArchive) == 0)
    {
        *pResource = reinterpret_cast<const void*>(m_pPreviewSoundArchive);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::PreviewEffectManager) == 0)
    {
        *pResource = reinterpret_cast<const void*>(m_pPreviewEffectManager);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::PreviewEffectManagerDrc) == 0)
    {
        *pResource = reinterpret_cast<const void*>(m_pPreviewEffectManagerDrc);
        return true;
    }

    if(nw::ut::stricmp(pLocalPath, GlobalResources::SoundEditSession) == 0)
    {
        *pResource = reinterpret_cast<const void*>(m_pSoundEditSession);
        return true;
    }

    return false;
}

} // snd
} // nw
