﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <panels/cafe/SoundParameterCafePanel.h>

namespace nw {
namespace snd {

static const BiquadFilterType s_BiquadFilterValues[] =
{
    BIQUAD_FILTER_TYPE_INHERIT,
    BIQUAD_FILTER_TYPE_NONE,
    BIQUAD_FILTER_TYPE_LPF,
    BIQUAD_FILTER_TYPE_HPF,
    BIQUAD_FILTER_TYPE_BPF512,
    BIQUAD_FILTER_TYPE_BPF1024,
    BIQUAD_FILTER_TYPE_BPF2048,
};

//---------------------------------------------------------------------------

static f32 GetMainSend(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainSend();
}

static f32 GetFxSendA(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetFxSend(AUX_BUS_A);
}

static f32 GetFxSendB(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetFxSend(AUX_BUS_B);
}

static f32 GetFxSendC(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetFxSend(AUX_BUS_C);
}

static f32 GetLpfFrequency(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetLpfFrequency();
}

static BiquadFilterType GetBiquadFilterType(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetBiquadFilterType();
}

static f32 GetBiquadFilterValue(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetBiquadFilterValue();
}

static f32 GetMainOutVolume(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainOutVolume();
}

static f32 GetDrcOutVolume(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcOutVolume();
}

static f32 GetRemote0OutVolume(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetRemote0OutVolume();
}

static f32 GetRemote1OutVolume(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetRemote1OutVolume();
}

static f32 GetRemote2OutVolume(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetRemote2OutVolume();
}

static f32 GetRemote3OutVolume(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetRemote3OutVolume();
}

static f32 GetMainPan(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainPan();
}

static f32 GetMainSurroundPan(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainSurroundPan();
}

static f32 GetMainMainSend(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainMainSend();
}

static f32 GetMainFxSendA(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainFxSend(AUX_BUS_A);
}

static f32 GetMainFxSendB(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainFxSend(AUX_BUS_B);
}

static f32 GetMainFxSendC(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetMainFxSend(AUX_BUS_C);
}

static f32 GetDrcPan(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcPan();
}

static f32 GetDrcSurroundPan(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcSurroundPan();
}

static f32 GetDrcMainSend(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcMainSend();
}

static f32 GetDrcFxSendA(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcFxSend(AUX_BUS_A);
}

static f32 GetDrcFxSendB(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcFxSend(AUX_BUS_B);
}

static f32 GetDrcFxSendC(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetDrcFxSend(AUX_BUS_C);
}

static void SetMainSend(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainSend(value);
}

static void SetFxSendA(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetFxSend(AUX_BUS_A, value);
}

static void SetFxSendB(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetFxSend(AUX_BUS_B, value);
}

static void SetFxSendC(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetFxSend(AUX_BUS_C, value);
}

static void SetLpfFrequency(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetLpfFrequency(value);
}

static void SetBiquadFilterType(PreviewSound* pPreviewSound, BiquadFilterType value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetBiquadFilterType(value);
}

static void SetBiquadFilterValue(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetBiquadFilterValue(value);
}

static void SetMainOutVolume(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainOutVolume(value);
}

static void SetDrcOutVolume(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcOutVolume(value);
}

static void SetRemote0OutVolume(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetRemote0OutVolume(value);
}

static void SetRemote1OutVolume(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetRemote1OutVolume(value);
}

static void SetRemote2OutVolume(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetRemote2OutVolume(value);
}

static void SetRemote3OutVolume(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetRemote3OutVolume(value);
}
static void SetMainPan(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainPan(value);
}

static void SetMainSurroundPan(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainSurroundPan(value);
}

static void SetMainMainSend(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainMainSend(value);
}

static void SetMainFxSendA(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainFxSend(AUX_BUS_A, value);
}

static void SetMainFxSendB(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainFxSend(AUX_BUS_B, value);
}

static void SetMainFxSendC(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetMainFxSend(AUX_BUS_C, value);
}

static void SetDrcPan(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcPan(value);
}

static void SetDrcSurroundPan(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcSurroundPan(value);
}

static void SetDrcMainSend(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcMainSend(value);
}

static void SetDrcFxSendA(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcFxSend(AUX_BUS_A, value);
}

static void SetDrcFxSendB(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcFxSend(AUX_BUS_B, value);
}

static void SetDrcFxSendC(PreviewSound* pPreviewSound, f32 value)
{
    NW_ASSERT(pPreviewSound != NULL);
    pPreviewSound->SetDrcFxSend(AUX_BUS_C, value);
}

static bool GetIsMainOutVolumeChecked(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetIsMainOutEnabled();
}

static bool GetIsDrcOutVolumeChecked(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetIsDrcOutEnabled();
}

static bool GetIsRemote0OutVolumeChecked(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetIsRemote0OutEnabled();
}

static bool GetIsRemote1OutVolumeChecked(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetIsRemote1OutEnabled();
}

static bool GetIsRemote2OutVolumeChecked(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetIsRemote2OutEnabled();
}

static bool GetIsRemote3OutVolumeChecked(PreviewSound* pPreviewSound)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->GetIsRemote3OutEnabled();
}

static void SetIsMainOutVolumeChecked(PreviewSound* pPreviewSound, bool value)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->SetIsMainOutEnabled(value);
}

static void SetIsDrcOutVolumeChecked(PreviewSound* pPreviewSound, bool value)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->SetIsDrcOutEnabled(value);
}

static void SetIsRemote0OutVolumeChecked(PreviewSound* pPreviewSound, bool value)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->SetIsRemote0OutEnabled(value);
}

static void SetIsRemote1OutVolumeChecked(PreviewSound* pPreviewSound, bool value)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->SetIsRemote1OutEnabled(value);
}

static void SetIsRemote2OutVolumeChecked(PreviewSound* pPreviewSound, bool value)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->SetIsRemote2OutEnabled(value);
}

static void SetIsRemote3OutVolumeChecked(PreviewSound* pPreviewSound, bool value)
{
    NW_ASSERT(pPreviewSound != NULL);
    return pPreviewSound->SetIsRemote3OutEnabled(value);
}

static void PrintF32Value(char* pText, u32 bufferLength, f32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%4.2f", value);
}

static void PrintBiquadFilterType(char* pText, u32 bufferLength, BiquadFilterType value)
{
    const char* pValueText = "";

    switch(value)
    {
    case BIQUAD_FILTER_TYPE_INHERIT:
        pValueText = "INHERIT";
        break;

    case BIQUAD_FILTER_TYPE_NONE:
        pValueText = "NONE";
        break;

    case BIQUAD_FILTER_TYPE_LPF:
        pValueText = "LPF";
        break;

    case BIQUAD_FILTER_TYPE_HPF:
        pValueText = "HPF";
        break;

    case BIQUAD_FILTER_TYPE_BPF512:
        pValueText = "BPF512";
        break;

    case BIQUAD_FILTER_TYPE_BPF1024:
        pValueText = "BPF1024";
        break;

    case BIQUAD_FILTER_TYPE_BPF2048:
        pValueText = "BPF2048";
        break;
    }

    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%s", pValueText);
}

//---------------------------------------------------------------------------

SoundParameterCafePanel::SoundParameterCafePanel() :
m_BiquadFilterTypeControl(BIQUAD_FILTER_TYPE_NONE)
{
    m_MainSendControl.Initialize(GetMainSend, SetMainSend, PrintF32Value);
    m_MainSendControl.SetLabelText("MainSend:");
    m_MainSendControl.SetMinimumValue(-1.f);
    m_MainSendControl.SetMaximumValue(1.f);
    m_MainSendControl.SetDefaultValue(0.f);
    m_MainSendControl.SetValueChange(0.01f);
    m_MainSendControl.SetValueLargeChange(0.1f);

    m_FxSendAControl.Initialize(GetFxSendA, SetFxSendA, PrintF32Value);
    m_FxSendAControl.SetLabelText("FxSendA:");
    m_FxSendAControl.SetMinimumValue(-1.f);
    m_FxSendAControl.SetMaximumValue(1.f);
    m_FxSendAControl.SetDefaultValue(0.f);
    m_FxSendAControl.SetValueChange(0.01f);
    m_FxSendAControl.SetValueLargeChange(0.1f);

    m_FxSendBControl.Initialize(GetFxSendB, SetFxSendB, PrintF32Value);
    m_FxSendBControl.SetLabelText("FxSendB:");
    m_FxSendBControl.SetMinimumValue(-1.f);
    m_FxSendBControl.SetMaximumValue(1.f);
    m_FxSendBControl.SetDefaultValue(0.f);
    m_FxSendBControl.SetValueChange(0.01f);
    m_FxSendBControl.SetValueLargeChange(0.1f);

    m_FxSendCControl.Initialize(GetFxSendC, SetFxSendC, PrintF32Value);
    m_FxSendCControl.SetLabelText("FxSendC:");
    m_FxSendCControl.SetMinimumValue(-1.f);
    m_FxSendCControl.SetMaximumValue(1.f);
    m_FxSendCControl.SetDefaultValue(0.f);
    m_FxSendCControl.SetValueChange(0.01f);
    m_FxSendCControl.SetValueLargeChange(0.1f);

    m_LpfFrequencyControl.Initialize(GetLpfFrequency, SetLpfFrequency, PrintF32Value);
    m_LpfFrequencyControl.SetLabelText("LpfFrequency:");
    m_LpfFrequencyControl.SetMinimumValue(-1.f);
    m_LpfFrequencyControl.SetMaximumValue(0.f);
    m_LpfFrequencyControl.SetDefaultValue(0.f);
    m_LpfFrequencyControl.SetValueChange(0.01f);
    m_LpfFrequencyControl.SetValueLargeChange(0.1f);

    m_BiquadFilterTypeControl.Initialize(
        s_BiquadFilterValues,
        sizeof(s_BiquadFilterValues) / sizeof(BiquadFilterType),
        GetBiquadFilterType,
        SetBiquadFilterType,
        PrintBiquadFilterType);
    m_BiquadFilterTypeControl.SetLabelText("BqfType:");

    m_BiquadFilterValueControl.Initialize(GetBiquadFilterValue, SetBiquadFilterValue, PrintF32Value);
    m_BiquadFilterValueControl.SetLabelText("BqfValue:");
    m_BiquadFilterValueControl.SetMinimumValue(0.f);
    m_BiquadFilterValueControl.SetMaximumValue(1.f);
    m_BiquadFilterValueControl.SetDefaultValue(0.5f);
    m_BiquadFilterValueControl.SetValueChange(0.01f);
    m_BiquadFilterValueControl.SetValueLargeChange(0.1f);

    m_MainOutVolumeControl.Initialize(
        GetIsMainOutVolumeChecked, SetIsMainOutVolumeChecked,
        GetMainOutVolume, SetMainOutVolume, PrintF32Value);
    m_MainOutVolumeControl.SetLabelText("MainOutVolume:");
    m_MainOutVolumeControl.SetMinimumValue(0.f);
    m_MainOutVolumeControl.SetMaximumValue(4.f);
    m_MainOutVolumeControl.SetDefaultValue(1.f);
    m_MainOutVolumeControl.SetValueChange(0.01f);
    m_MainOutVolumeControl.SetValueLargeChange(0.1f);

    m_DrcOutVolumeControl.Initialize(
        GetIsDrcOutVolumeChecked, SetIsDrcOutVolumeChecked,
        GetDrcOutVolume, SetDrcOutVolume, PrintF32Value);
    m_DrcOutVolumeControl.SetLabelText("DrcOutVolume:");
    m_DrcOutVolumeControl.SetMinimumValue(0.f);
    m_DrcOutVolumeControl.SetMaximumValue(4.f);
    m_DrcOutVolumeControl.SetDefaultValue(1.f);
    m_DrcOutVolumeControl.SetValueChange(0.01f);
    m_DrcOutVolumeControl.SetValueLargeChange(0.1f);

    m_Remote0OutVolumeControl.Initialize(
        GetIsRemote0OutVolumeChecked, SetIsRemote0OutVolumeChecked,
        GetRemote0OutVolume, SetRemote0OutVolume, PrintF32Value);
    m_Remote0OutVolumeControl.SetLabelText("Remote0OutVolume:");
    m_Remote0OutVolumeControl.SetMinimumValue(0.f);
    m_Remote0OutVolumeControl.SetMaximumValue(4.f);
    m_Remote0OutVolumeControl.SetDefaultValue(1.f);
    m_Remote0OutVolumeControl.SetValueChange(0.01f);
    m_Remote0OutVolumeControl.SetValueLargeChange(0.1f);

    m_Remote1OutVolumeControl.Initialize(
        GetIsRemote1OutVolumeChecked, SetIsRemote1OutVolumeChecked,
        GetRemote1OutVolume, SetRemote1OutVolume, PrintF32Value);
    m_Remote1OutVolumeControl.SetLabelText("Remote1OutVolume:");
    m_Remote1OutVolumeControl.SetMinimumValue(0.f);
    m_Remote1OutVolumeControl.SetMaximumValue(4.f);
    m_Remote1OutVolumeControl.SetDefaultValue(1.f);
    m_Remote1OutVolumeControl.SetValueChange(0.01f);
    m_Remote1OutVolumeControl.SetValueLargeChange(0.1f);

    m_Remote2OutVolumeControl.Initialize(
        GetIsRemote2OutVolumeChecked, SetIsRemote2OutVolumeChecked,
        GetRemote2OutVolume, SetRemote2OutVolume, PrintF32Value);
    m_Remote2OutVolumeControl.SetLabelText("Remote2OutVolume:");
    m_Remote2OutVolumeControl.SetMinimumValue(0.f);
    m_Remote2OutVolumeControl.SetMaximumValue(4.f);
    m_Remote2OutVolumeControl.SetDefaultValue(1.f);
    m_Remote2OutVolumeControl.SetValueChange(0.01f);
    m_Remote2OutVolumeControl.SetValueLargeChange(0.1f);

    m_Remote3OutVolumeControl.Initialize(
        GetIsRemote3OutVolumeChecked, SetIsRemote3OutVolumeChecked,
        GetRemote3OutVolume, SetRemote3OutVolume, PrintF32Value);
    m_Remote3OutVolumeControl.SetLabelText("Remote3OutVolume:");
    m_Remote3OutVolumeControl.SetMinimumValue(0.f);
    m_Remote3OutVolumeControl.SetMaximumValue(4.f);
    m_Remote3OutVolumeControl.SetDefaultValue(1.f);
    m_Remote3OutVolumeControl.SetValueChange(0.01f);
    m_Remote3OutVolumeControl.SetValueLargeChange(0.1f);

    m_MainPanControl.Initialize(GetMainPan, SetMainPan, PrintF32Value);
    m_MainPanControl.SetLabelText("Pan(Main):");
    m_MainPanControl.SetMinimumValue(-2.f);
    m_MainPanControl.SetMaximumValue(2.f);
    m_MainPanControl.SetDefaultValue(0.f);
    m_MainPanControl.SetValueChange(0.01f);
    m_MainPanControl.SetValueLargeChange(0.1f);

    m_MainSurroundPanControl.Initialize(GetMainSurroundPan, SetMainSurroundPan, PrintF32Value);
    m_MainSurroundPanControl.SetLabelText("SPan(Main):");
    m_MainSurroundPanControl.SetMinimumValue(-2.f);
    m_MainSurroundPanControl.SetMaximumValue(2.f);
    m_MainSurroundPanControl.SetDefaultValue(0.f);
    m_MainSurroundPanControl.SetValueChange(0.01f);
    m_MainSurroundPanControl.SetValueLargeChange(0.1f);

    m_MainMainSendControl.Initialize(GetMainMainSend, SetMainMainSend, PrintF32Value);
    m_MainMainSendControl.SetLabelText("MainSend(Main):");
    m_MainMainSendControl.SetMinimumValue(-1.f);
    m_MainMainSendControl.SetMaximumValue(1.f);
    m_MainMainSendControl.SetDefaultValue(0.f);
    m_MainMainSendControl.SetValueChange(0.01f);
    m_MainMainSendControl.SetValueLargeChange(0.1f);

    m_MainFxSendAControl.Initialize(GetMainFxSendA, SetMainFxSendA, PrintF32Value);
    m_MainFxSendAControl.SetLabelText("FxSendA(Main):");
    m_MainFxSendAControl.SetMinimumValue(-1.f);
    m_MainFxSendAControl.SetMaximumValue(1.f);
    m_MainFxSendAControl.SetDefaultValue(0.f);
    m_MainFxSendAControl.SetValueChange(0.01f);
    m_MainFxSendAControl.SetValueLargeChange(0.1f);

    m_MainFxSendBControl.Initialize(GetMainFxSendB, SetMainFxSendB, PrintF32Value);
    m_MainFxSendBControl.SetLabelText("FxSendB(Main):");
    m_MainFxSendBControl.SetMinimumValue(-1.f);
    m_MainFxSendBControl.SetMaximumValue(1.f);
    m_MainFxSendBControl.SetDefaultValue(0.f);
    m_MainFxSendBControl.SetValueChange(0.01f);
    m_MainFxSendBControl.SetValueLargeChange(0.1f);

    m_MainFxSendCControl.Initialize(GetMainFxSendC, SetMainFxSendC, PrintF32Value);
    m_MainFxSendCControl.SetLabelText("FxSendC(Main):");
    m_MainFxSendCControl.SetMinimumValue(-1.f);
    m_MainFxSendCControl.SetMaximumValue(1.f);
    m_MainFxSendCControl.SetDefaultValue(0.f);
    m_MainFxSendCControl.SetValueChange(0.01f);
    m_MainFxSendCControl.SetValueLargeChange(0.1f);

    m_DrcPanControl.Initialize(GetDrcPan, SetDrcPan, PrintF32Value);
    m_DrcPanControl.SetLabelText("Pan(DRC):");
    m_DrcPanControl.SetMinimumValue(-2.f);
    m_DrcPanControl.SetMaximumValue(2.f);
    m_DrcPanControl.SetDefaultValue(0.f);
    m_DrcPanControl.SetValueChange(0.01f);
    m_DrcPanControl.SetValueLargeChange(0.1f);

    m_DrcSurroundPanControl.Initialize(GetDrcSurroundPan, SetDrcSurroundPan, PrintF32Value);
    m_DrcSurroundPanControl.SetLabelText("SPan(DRC):");
    m_DrcSurroundPanControl.SetMinimumValue(-2.f);
    m_DrcSurroundPanControl.SetMaximumValue(2.f);
    m_DrcSurroundPanControl.SetDefaultValue(0.f);
    m_DrcSurroundPanControl.SetValueChange(0.01f);
    m_DrcSurroundPanControl.SetValueLargeChange(0.1f);

    m_DrcMainSendControl.Initialize(GetDrcMainSend, SetDrcMainSend, PrintF32Value);
    m_DrcMainSendControl.SetLabelText("MainSend(DRC):");
    m_DrcMainSendControl.SetMinimumValue(-1.f);
    m_DrcMainSendControl.SetMaximumValue(1.f);
    m_DrcMainSendControl.SetDefaultValue(0.f);
    m_DrcMainSendControl.SetValueChange(0.01f);
    m_DrcMainSendControl.SetValueLargeChange(0.1f);

    m_DrcFxSendAControl.Initialize(GetDrcFxSendA, SetDrcFxSendA, PrintF32Value);
    m_DrcFxSendAControl.SetLabelText("FxSendA(DRC):");
    m_DrcFxSendAControl.SetMinimumValue(-1.f);
    m_DrcFxSendAControl.SetMaximumValue(1.f);
    m_DrcFxSendAControl.SetDefaultValue(0.f);
    m_DrcFxSendAControl.SetValueChange(0.01f);
    m_DrcFxSendAControl.SetValueLargeChange(0.1f);

    m_DrcFxSendBControl.Initialize(GetDrcFxSendB, SetDrcFxSendB, PrintF32Value);
    m_DrcFxSendBControl.SetLabelText("FxSendB(DRC):");
    m_DrcFxSendBControl.SetMinimumValue(-1.f);
    m_DrcFxSendBControl.SetMaximumValue(1.f);
    m_DrcFxSendBControl.SetDefaultValue(0.f);
    m_DrcFxSendBControl.SetValueChange(0.01f);
    m_DrcFxSendBControl.SetValueLargeChange(0.1f);

    m_DrcFxSendCControl.Initialize(GetDrcFxSendC, SetDrcFxSendC, PrintF32Value);
    m_DrcFxSendCControl.SetLabelText("FxSendC(DRC):");
    m_DrcFxSendCControl.SetMinimumValue(-1.f);
    m_DrcFxSendCControl.SetMaximumValue(1.f);
    m_DrcFxSendCControl.SetDefaultValue(0.f);
    m_DrcFxSendCControl.SetValueChange(0.01f);
    m_DrcFxSendCControl.SetValueLargeChange(0.1f);

    AddItem(m_MainSendControl);
    AddItem(m_FxSendAControl);
    AddItem(m_FxSendBControl);
    AddItem(m_FxSendCControl);
    AddItem(m_LpfFrequencyControl);
    AddItem(m_BiquadFilterTypeControl);
    AddItem(m_BiquadFilterValueControl);
    AddItem(m_MainOutVolumeControl);
    AddItem(m_DrcOutVolumeControl);
    AddItem(m_Remote0OutVolumeControl);
    AddItem(m_Remote1OutVolumeControl);
    AddItem(m_Remote2OutVolumeControl);
    AddItem(m_Remote3OutVolumeControl);
    AddItem(m_MainPanControl);
    AddItem(m_MainSurroundPanControl);
    AddItem(m_MainMainSendControl);
    AddItem(m_MainFxSendAControl);
    AddItem(m_MainFxSendBControl);
    AddItem(m_MainFxSendCControl);
    AddItem(m_DrcPanControl);
    AddItem(m_DrcSurroundPanControl);
    AddItem(m_DrcMainSendControl);
    AddItem(m_DrcFxSendAControl);
    AddItem(m_DrcFxSendBControl);
    AddItem(m_DrcFxSendCControl);
}

} // snd
} // nw
