﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/SetOutputModeHandler.h>

namespace
{

enum HioOutputMode
{
    //! @brief  無効値
    HIO_OUTPUT_MODE_INVALID = 0,

    //! @brief  モノラル
    HIO_OUTPUT_MODE_MONO = 1,

    //! @brief  ステレオ
    HIO_OUTPUT_MODE_STEREO = 2,

    //! @brief  サラウンド
    HIO_OUTPUT_MODE_SURROUND = 3,

    //! @brief  DPL2
    HIO_OUTPUT_MODE_DPL2 = 4,
};

nw::snd::OutputMode ToOutputMode(u32 value)
{
    switch(static_cast<HioOutputMode>(value))
    {
    case HIO_OUTPUT_MODE_MONO:
        return nw::snd::OUTPUT_MODE_MONO;

    case HIO_OUTPUT_MODE_STEREO:
        return nw::snd::OUTPUT_MODE_STEREO;

    case HIO_OUTPUT_MODE_SURROUND:
        return nw::snd::OUTPUT_MODE_SURROUND;

    case HIO_OUTPUT_MODE_DPL2:
        return nw::snd::OUTPUT_MODE_DPL2;
    }

    return nw::snd::OUTPUT_MODE_STEREO;
}

struct PacketData
{
    nw::snd::internal::fnd::BinU32 mainOutputMode;
    nw::snd::internal::fnd::BinU32 drcOutputMode;
};

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
SetOutputModeHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("SetOutputModeHandler\n");
#endif

    NW_NULL_ASSERT(data);

    const PacketData* request = reinterpret_cast<const PacketData*>(data);
    nw::snd::SoundSystem::SetOutputMode(ToOutputMode(request->mainOutputMode), OUTPUT_DEVICE_MAIN);
    nw::snd::SoundSystem::SetOutputMode(ToOutputMode(request->drcOutputMode), OUTPUT_DEVICE_DRC);
}

} // snd
} // nw
