﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/SetAnimationRateHandler.h>
#include <anim/GfxCoordinator.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
SetAnimationRateHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
    internal::fnd::BinF32 rate =
        *(reinterpret_cast<const internal::fnd::BinF32*>(data));

#if defined(NW_DEBUG)
    NW_LOG("[HIO] set animation rate. : %d\n", f32(rate));
#endif

    if (GfxCoordinator::IsInitialized())
    {
        GfxCoordinator::GetInstance().SetRate(rate);
    }
}

} // snd
} // nw
