﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Delegate.h>
#include <nw/ut/ut_Memory.h>
#include <nw/snd/fnd/io/sndfnd_AiffStream.h>
#include <nw/snd/fnd/io/sndfnd_WavStream.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_StackPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/dw/control/dw_FileBrowser.h>
#include <controls/Lamp.h>
#include <io/ASyncWaveReader.h>

namespace nw {
namespace snd {

class WaveRenderer;

namespace internal {
namespace fnd {
class FileStream;
}
}

class WavePreviewPanel : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_FILE_PATH = 256;
    static const u32 READ_BUFFER_LENGTH = 8 * 1024;

public:
    WavePreviewPanel();
    virtual ~WavePreviewPanel();

protected:
    void Initialize(ut::IAllocator* allocator, nw::internal::dw::FileBrowser& fileBrowser);
    void Finalize();

    ut::IAllocator* GetAllocator() { return m_Allocator; }

    virtual internal::fnd::FileStream* OpenFileImpl(const char* filePath) = 0;
    virtual internal::fnd::FileStream* GetOpenedFileStream() = 0;
    virtual WaveRenderer& GetWaveRenderer() = 0;

    virtual void InitializeLampBar(nw::internal::dw::StackPanel& lampBar) = 0;
    virtual void SetOutputLine(WaveRenderer& renderer) = 0;

    virtual bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

    virtual void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    bool OpenWaveFile(const char* pPath);
    void CloseWaveFile();

    void OnFilterFile(nw::internal::dw::FileBrowserFilterEventArgs& args);
    void OnExecuteFile(nw::internal::dw::FileBrowserExecuteEventArgs& args);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<3> m_Container;

    nw::internal::dw::FixedLabel<MAX_FILE_PATH> m_CurrentDirectoryLabel;
    nw::internal::dw::FileBrowser* m_pFileBrowser;

    nw::internal::dw::StackPanel m_LampBar;

    internal::fnd::AiffStreamReader m_AiffReader;
    internal::fnd::WavStreamReader m_WavReader;
    internal::fnd::WaveformStreamReader* m_pCurrentReader;
    ASyncWaveReader m_ASyncWaveReader;

    ut::IAllocator* m_Allocator;
    void* m_ReadFileBuffer;

    ut::Delegate1<WavePreviewPanel, void, nw::internal::dw::FileBrowserFilterEventArgs&> m_FileFilterEventHandler;
    ut::Delegate1<WavePreviewPanel, void, nw::internal::dw::FileBrowserExecuteEventArgs&> m_FileExecuteEventHandler;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "WavePreviewPanel";
    }
#endif
};

} // snd
} // nw
