﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/snd.h>
#include <nw/snd/fnd/io/sndfnd_FileStreamImpl.h>
#include <controls/FixedLabelPeakMeter.h>
#include <controls/Lamp.h>

namespace nw {

namespace ut{
class IAllocator;
}

namespace snd {

class IResourceProvider;

class PerformancePanel : public nw::internal::dw::UIElement
{
private:
    static const s32 INVALID_INDEX = -1;

    static const char* SOUNDTHREAD_CPU_LABEL;
    static const char* SOUNDTHREAD_SND_LABEL;
    static const char* SOUNDTHREAD_SNDCB_LABEL;
    static const char* SOUNDTHREAD_SNDTH_LABEL;
    static const char* SOUNDTHREAD_AUX_LABEL;
    static const char* SOUNDTHREAD_AX_LABEL;
    static const char* SOUNDTHREAD_DSP_LABEL;
    static const char* SOUNDTHREAD_SNDINT_LABEL;
    static const char* SOUNDTHREAD_AXINT_LABEL;

    static const s32 LABEL_LENGTH = 32;
    static const u32 MAX_LOG_FILE_PATH = 280;
    static const u32 LOG_BUFFER_LENGTH = 8 * 1024;
    static const u32 LOG_WRITE_FORMAT_BUFFER_LENGTH = 256;

    enum
    {
        SOUNDTHREAD_CPU_INDEX,
        SOUNDTHREAD_SND_INDEX,
        SOUNDTHREAD_SNDCB_INDEX,
        SOUNDTHREAD_SNDTH_INDEX,
        SOUNDTHREAD_AUX_INDEX,
        SOUNDTHREAD_AX_INDEX,
        SOUNDTHREAD_DSP_INDEX,
        SOUNDTHREAD_SNDINT_INDEX,
        SOUNDTHREAD_AXINT_INDEX,
        PERFORMANCE_BAR_COUNT
    };

    enum LoggingState
    {
        LOGGING_STATE_IDLE,
        LOGGING_STATE_PREPARING,
        LOGGING_STATE_RUNNING,
    };

    struct ProfileData
    {
        nw::ut::TimeSpan axFrame;
        nw::ut::TimeSpan axFrameInterval;
        nw::ut::TimeSpan auxProcessing;
        nw::ut::TimeSpan userCallback;
        nw::ut::TimeSpan sndFrame;
        nw::ut::TimeSpan sndFrameInterval;
        nw::ut::TimeSpan dspFrame;
        u32 axNumVoices;
    };

public:
    PerformancePanel();

public:
    bool Initialize(IResourceProvider& resourceProvider);
    void Finalize();

    bool IsVideoFrameProfile()
    {
        return m_IsVideoFrameProfile;
    }

    bool IsLogging();

    Lamp* GetLogLamp() { return m_pLogLamp; }
    void  SetLogLamp(Lamp* pLogLamp);

protected:
    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    void SetProfileMode(bool isVideoFrameProfile)
    {
        m_IsVideoFrameProfile = isVideoFrameProfile;
    }

    void StartLogging();
    void StopLogging();

    void SetLoggingState(LoggingState state);
    void SetMeter(int index, f32 value);

#ifdef NW_PLATFORM_CAFE
    void UpdateVideoFrameProfiles(const nw::snd::SoundProfile* pProfile, u32 profileCount);
    void UpdateAudioFrameProfiles(const nw::snd::SoundProfile* pProfile, u32 profileCount);

    s32 UpdateLoggingState(const nw::snd::SoundProfile* pProfile, u32 profileCount);
    void LogProfiles(const nw::snd::SoundProfile* pProfile, u32 profileCount, u32 startIndex);
#endif

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<PERFORMANCE_BAR_COUNT> m_Container;

    FixedLabelPeakMeter<LABEL_LENGTH> m_PerformanceMeters[PERFORMANCE_BAR_COUNT];
    Lamp* m_pLogLamp;

    bool m_IsVideoFrameProfile;

#if !defined(NW_PLATFORM_WIN32) && !defined(NW_USE_NINTENDO_SDK)
    ProfileReader m_ProfileReader;
    nw::ut::Tick  m_PrevAxFrameProcessBegin;
    nw::ut::Tick  m_PrevNwFrameProcessBegin;
    nw::ut::Tick  m_PrevAxFrameProcessBeginForLogging;
    nw::ut::Tick  m_PrevNwFrameProcessBeginForLogging;
#endif

    LoggingState m_LoggingState;
    u32 m_LogCurrentFrame;
    internal::fnd::FileStreamImpl m_LogFile;
    internal::fnd::StreamWriter m_LogWriter;
    void* m_LogBuffer;
    u8 m_LogWriteFormatBuffer[LOG_WRITE_FORMAT_BUFFER_LENGTH];

    ut::IAllocator* m_Allocator;

#if defined(NW_PLATFORM_CAFE)
    FSClient* m_FsClient;
    FSCmdBlock* m_FsCmdBlock;
    const char* m_HfioVolume;
#endif

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "PerformancePanel";
    }
#endif
};

} // snd
} // nw
