﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Delegate.h>
#include <nw/snd/snd_SoundThread.h>
#include <models/PreviewAuxBus.h>
#include <models/PreviewEffectSet.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief PreviewEffectManager
//---------------------------------------------------------------------------
    class PreviewEffectManager : public snd::internal::driver::SoundThread::SoundFrameCallback
{
public:
    static const s32 AUX_BUS_COUNT = 3;
    static const s32 EFFECT_COUNT = 3;

    typedef ut::DelegateEvent0 AppliedEvent;
    typedef AppliedEvent::Slot AppliedEventHandler;

public:
    PreviewEffectManager();

public:
    void Initialize(void* pBuffer, u32 bufferSize, OutputDevice device);
    void Finalize();

    u32 GetAssinedSize() { return m_AssinedSize; }

    PreviewAuxBus* GetAuxBus(s32 auxBusIndex);
    PreviewAuxBus* GetAuxBus(AuxBus auxBus);

    void Update();

    void Apply();
    void Clear();

    AppliedEvent& GetAppliedEvent() { return m_AppliedEvent; }

protected:
    /* override */ void OnBeginSoundFrame();

private:
    bool GetIsDirty() const;
    void ResetIsDirty();

    AuxBus IndexToAuxBus(s32 value);
    s32 AuxBusToIndex(AuxBus value);

    void UpdateChannelMode(OutputDevice device);

private:
    PreviewAuxBus m_AuxBuses[AUX_BUS_COUNT];
    PreviewEffectSet m_AuxBusEffects[AUX_BUS_COUNT][EFFECT_COUNT];

    u32 m_AssinedSize;

    AppliedEvent m_AppliedEvent;
};

} // nw::snd
} // nw
