﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Delegate.h>
#include <models/PreviewSound.h>

namespace nw {
namespace snd {

class IPreviewSoundSelector
{
public:
    typedef ut::DelegateEvent0 SelectionChangedEvent;
    typedef SelectionChangedEvent::Slot SelectionChangedEventHandler;

public:
    virtual PreviewSound* GetSelectedPreviewSoundFirst() const = 0;

    virtual SelectionChangedEvent& GetSelectionChangedEvent() = 0;
};

} // snd
} // nw
