﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4F_VIEWER_PREVIEWPLAYERPARAMETER_H_
#define NW4F_VIEWER_PREVIEWPLAYERPARAMETER_H_

#pragma once

#include <nw/snd.h>

namespace nw    {
namespace snd   {


///
#define DECLARE_PROPERTY_WITH_USERHANDLER( type, name, handler )    \
                private:                                            \
                    type              m_##name;                     \
                    static const type name##Default;                \
                public:                                             \
                    void Set##name( type value )                    \
                    {                                               \
                        if( value == m_##name ) return;             \
                        m_##name = value;                           \
                        handler();                                  \
                    }                                               \
                    type Get##name()                                \
                    {                                               \
                        return m_##name;                            \
                    }

#define DECLARE_RANGEPROPERTY_WITH_USERHANDLER( type, name, handler )   \
                private:                                                \
                    type              m_##name;                         \
                    static const type name##Default;                    \
                    static const type name##Min;                        \
                    static const type name##Max;                        \
                public:                                                 \
                    void Set##name( type value )                        \
                    {                                                   \
                        if( value == m_##name ) return;                 \
                        NW_ASSERT( value >= name##Min );                \
                        NW_ASSERT( value <= name##Max );                \
                        m_##name = value;                               \
                        handler();                                      \
                    }                                                   \
                    type Get##name()                                    \
                    {                                                   \
                        return m_##name;                                \
                    }

#define INIT_PROPERTY_VALUE( name ) m_##name( name##Default )

#define INIT_RANGEPROPERTY_CONST( type, classname, name, min, max, def )    \
                const type classname::name##Default = def;                  \
                const type classname::name##Min     = min;                  \
                const type classname::name##Max     = max;

#define INIT_PROPERTY_CONST( type, classname, name, def )   \
                const type classname::name##Default = def;


///
class PreviewPlayerParameter
{
public:
    PreviewPlayerParameter();

public: // プロパティ
    // パラメータの操作
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float,            Volume,          OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float,            Pitch,           OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float,            Pan,             OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float,            SurroundPan,     OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float,            LpfFrequency,    OnInternalParameterChanged )
    DECLARE_PROPERTY_WITH_USERHANDLER     ( BiquadFilterType, BiquadType,      OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float,            BiquadValue,     OnInternalParameterChanged )
    DECLARE_PROPERTY_WITH_USERHANDLER     ( u32,              StartOffsetTime, OnInternalParameterChanged )

    DECLARE_PROPERTY_WITH_USERHANDLER     ( bool, MainOutEnabled,    OnInternalParameterChanged )
    DECLARE_PROPERTY_WITH_USERHANDLER     ( bool, Remote0OutEnabled, OnInternalParameterChanged )
    DECLARE_PROPERTY_WITH_USERHANDLER     ( bool, Remote1OutEnabled, OnInternalParameterChanged )
    DECLARE_PROPERTY_WITH_USERHANDLER     ( bool, Remote2OutEnabled, OnInternalParameterChanged )
    DECLARE_PROPERTY_WITH_USERHANDLER     ( bool, Remote3OutEnabled, OnInternalParameterChanged )

    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, MainOutVolume,    OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, Remote0OutVolume, OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, Remote1OutVolume, OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, Remote2OutVolume, OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, Remote3OutVolume, OnInternalParameterChanged )

    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, MainSend,       OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, EffectAuxASend, OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, EffectAuxBSend, OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( float, EffectAuxCSend, OnInternalParameterChanged )

    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( s32, FadeInFrames,    OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( s32, FadeOutFrames,   OnInternalParameterChanged )
    DECLARE_RANGEPROPERTY_WITH_USERHANDLER( s32, PauseFadeFrames, OnInternalParameterChanged )

public:
    // イベント制御
    void LockParameterChangedEvent();
    void UnlockParameterChangedEvent();

protected:  // イベントハンドラ
    virtual void OnParameterChanged() { }

private:    // 内部用イベントハンドラ
    void OnInternalParameterChanged();

private:    // パラメータ
    bool m_bParameterChangedEventLocked;
    bool m_bParameterDirty;
};


// パラメータ定数の初期化
INIT_RANGEPROPERTY_CONST( float,            PreviewPlayerParameter, Volume,           0.00f, 4.00f, 1.00f )
INIT_RANGEPROPERTY_CONST( float,            PreviewPlayerParameter, Pitch,            0.01f, 4.00f, 1.00f )
INIT_RANGEPROPERTY_CONST( float,            PreviewPlayerParameter, Pan,             -2.00f, 2.00f, 0.00f )
INIT_RANGEPROPERTY_CONST( float,            PreviewPlayerParameter, SurroundPan,     -2.00f, 2.00f, 0.00f )
INIT_RANGEPROPERTY_CONST( float,            PreviewPlayerParameter, LpfFrequency,    -1.00f, 1.00f, 0.00f )
INIT_PROPERTY_CONST     ( BiquadFilterType, PreviewPlayerParameter, BiquadType,      BIQUAD_FILTER_TYPE_NONE )
INIT_RANGEPROPERTY_CONST( float,            PreviewPlayerParameter, BiquadValue,      0.00f, 1.00f, 0.00f )
INIT_PROPERTY_CONST     ( u32,              PreviewPlayerParameter, StartOffsetTime,  0 )

INIT_PROPERTY_CONST     ( bool,  PreviewPlayerParameter, MainOutEnabled,    true )
INIT_PROPERTY_CONST     ( bool,  PreviewPlayerParameter, Remote0OutEnabled, false )
INIT_PROPERTY_CONST     ( bool,  PreviewPlayerParameter, Remote1OutEnabled, false )
INIT_PROPERTY_CONST     ( bool,  PreviewPlayerParameter, Remote2OutEnabled, false )
INIT_PROPERTY_CONST     ( bool,  PreviewPlayerParameter, Remote3OutEnabled, false )

INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, MainOutVolume,    0.00f, 4.00f, 1.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, Remote0OutVolume, 0.00f, 4.00f, 1.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, Remote1OutVolume, 0.00f, 4.00f, 1.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, Remote2OutVolume, 0.00f, 4.00f, 1.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, Remote3OutVolume, 0.00f, 4.00f, 1.00f )

INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, MainSend,       -1.00f, 4.00f, 0.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, EffectAuxASend, -1.00f, 4.00f, 0.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, EffectAuxBSend, -1.00f, 4.00f, 0.00f )
INIT_RANGEPROPERTY_CONST( float, PreviewPlayerParameter, EffectAuxCSend, -1.00f, 4.00f, 0.00f )

INIT_RANGEPROPERTY_CONST( s32,   PreviewPlayerParameter, FadeInFrames,    0, 600, 0 )
INIT_RANGEPROPERTY_CONST( s32,   PreviewPlayerParameter, FadeOutFrames,   0, 600, 0 )
INIT_RANGEPROPERTY_CONST( s32,   PreviewPlayerParameter, PauseFadeFrames, 0, 600, 0 )


} // namespace snd
} // namespace nw

#endif // NW4F_VIEWER_PREVIEWPLAYERPARAMETER_H_
