﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_VIEWER_EFFECTCONTROLLER_H_
#define NW4R_VIEWER_EFFECTCONTROLLER_H_

#pragma once

// Preview
#include "Effect.h"
#include <mcs/ItemContainer.h>

// マクロ
#define BUS_COUNT            3  /* 補助バス数 */
#define DEFAULT_EFFECTS_COUNT 10 /* 補助バス上にあるエフェクトのデフォルト数） */

//using namespace nw4r::snd;

namespace nw      {
namespace snd   {


class EffectController
{
private:
    //typedef nw::edit3d::vector<Effect*>::type EFFECTS;

public:
    EffectController(void);
    ~EffectController(void);

    // 初期化
    //Result Initialize(unsigned int nCount=DEFAULT_EFFECTS_COUNT);
    void Initialize(unsigned int nCount=DEFAULT_EFFECTS_COUNT);
    void   Uninitialize();

    // エフェクトの設定
    Effect* GetEffect(ToolSoundAuxBusType nBusType, unsigned int nEffectIndex);
    Effect* GetEffect(const ToolSoundEffectCommonParameter* pParam);

    // Result  SetEffectParameter(const ToolSoundEffectCommonParameter* pParam);
    // Result  SetEffectParameters(const ToolSoundItemContainer* pContainer);
    void  SetEffectParameter(const ToolSoundEffectCommonParameter* pParam);
    void  SetEffectParameters(const ToolSoundItemContainer* pContainer);

private:
    // エフェクト
    //EFFECTS m_pEffects[ BUS_COUNT ];    // エフェクトコンテナ
    Effect* m_pEffects[ BUS_COUNT ][ DEFAULT_EFFECTS_COUNT ];    // エフェクトコンテナ
    Effect* m_pEffectsBuffer;           // エフェクトバッファ
};


} // namespace snd
} // namespace nw

#endif // NW4R_VIEWER_EFFECTCONTROLLER_H_
