﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <io/WaveRenderer.h>

namespace nw {
namespace snd {

class WaveRendererCafe : public WaveRenderer
{
public:
    enum OutputLine
    {
        OUTPUT_MAIN    = 1 << 0,
        OUTPUT_REMOTE0 = 1 << 1,
        OUTPUT_REMOTE1 = 1 << 2,
        OUTPUT_REMOTE2 = 1 << 3,
        OUTPUT_REMOTE3 = 1 << 4,
        OUTPUT_DRC0    = 1 << 5,
    };

public:
    /* ctor */ WaveRendererCafe();
    /* dtor */ virtual ~WaveRendererCafe();

public:
    OutputLine GetOutputType() const;
    void SetOutputLine(OutputLine value);

protected:
    /* override */ void SetOutMix(internal::Voice& voice, const internal::fnd::WaveFormat& waveFormat, u32 channelIndex);

private:
    OutputLine m_OutputLine;
};

} // snd
} // nw
