﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <core/TaskThread.h>

namespace nw {
namespace snd {

class File;
class IStreamWriter;

class StreamWriteTask : public TaskThread::Task
{
private:
    static const u32 BUFFER_SIZE = 2 * 1024;

public:
    enum State
    {
        STATE_NOT_READY = 0,
        STATE_READY,
        STATE_DONE,
        STATE_ERROR,
    };

public:
    /* ctor */ StreamWriteTask();
    /* dtor */ ~StreamWriteTask();

public:
    State GetState() const;

    void Update(IStreamWriter& writer, const void* pBuffer, u32 size);

    /*override*/ void Invoke();

    void Reset();

private:
    State m_State;

    IStreamWriter* m_pWriter;

    u8  m_Buffer[BUFFER_SIZE];
    u32 m_DataSize;
};

} // snd
} // nw
