﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>

namespace nw {
namespace snd {

template<typename TValue, u32 Size, u32 Alignment>
class AlignedArray
{
public:
    AlignedArray()
    {
        if(Alignment == 0)
        {
            m_pValue = m_Array;
        }
        else
        {
            m_pValue = static_cast<u8*>(nw::ut::RoundUp(m_Array, Alignment));
        }

        NW_NULL_ASSERT(m_pValue);
    }

public:
    u32 GetSize()
    {
        return Size;
    }

    TValue& operator [](u32 index)
    {
        NW_ASSERT(index < Size);
        return m_pValue[index];
    }

    operator TValue*()
    {
        return m_pValue;
    }

private:
    TValue* m_pValue;
    TValue m_Array[Size + Alignment];
};

} // snd
} // nw
