﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListItem.h>

namespace nw {
namespace snd {

template<class TModel, typename TValue>
class SelectableParameterListItem : public ModelParameterListItem<TModel>
{
private:
    typedef ModelParameterListItem<TModel> Base;

public:
    typedef TValue (*GetValueHandler)(TModel* pModel);
    typedef void   (*SetValueHandler)(TModel* pModel, TValue value);
    typedef void   (*PrintValueHandler)(char* pText, u32 bufferLength, TValue value);

public:
    SelectableParameterListItem(TValue defaultValue);

public:
    void Initialize(
        const TValue* pValues,
        u32 valueCount,
        GetValueHandler pGetValueHandler,
        SetValueHandler pSetValueHandler,
        PrintValueHandler pPrintValueHandler);

    void Initialize(
        GetIsCheckedHandler pGetIsCheckedHandler,
        SetIsCheckedHandler pSetIsCheckedHandler,
        const TValue* pValues,
        u32 valueCount,
        GetValueHandler pGetValueHandler,
        SetValueHandler pSetValueHandler,
        PrintValueHandler pPrintValueHandler);

    TValue GetValue() const;
    void SetValue(TValue value);

    TValue GetDefaultValue() const;
    void SetDefaultValue(TValue value);

    /*override*/ void ResetValue();

protected:
    /*override*/ void NextValue(bool isLargeChange);
    /*override*/ void PreviousValue(bool isLargeChange);
    /*override*/ void PrintValue(char* pText, u32 bufferLength);

private:
    TValue m_DefaultValue;
    const TValue* m_pValues;
    u32 m_ValueCount;

    GetValueHandler m_pGetValueHandler;
    SetValueHandler m_pSetValueHandler;
    PrintValueHandler m_pPrintValueHandler;

#if defined(NW_DEBUG)

public:
    virtual const char* ToString() const
    {
        return "SelectableParameterListItem";
    }

#endif
};

} // snd
} // nw

#include "SelectableParameterListItem.hpp"
