﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListView.h>
#include <controls/F32ParameterListItem.h>
#include <controls/SelectableParameterListItem.h>
#include <models/PreviewEffect.h>

namespace nw {
namespace snd {

class ReverbStdParameterListView : public ParameterListView<PreviewEffectReverbStd, 16>
{
public:
    ReverbStdParameterListView();

protected:
    //! @brief UI要素サイズ計算の準備を行います。
    /* override */ void OnPrepareMeasure();

private:
    SelectableParameterListItem<PreviewEffectReverbStd, FxReverbEarlyReflectionMode> m_EaryReflectionModeControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_PreDelayTimeMaxControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_PreDelayTimeControl;
    SelectableParameterListItem<PreviewEffectReverbStd, FxReverbFusedMode> m_FusedModeControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_FusedTimeControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_ColorationControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_DampingControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_EarlyGainControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_FusedGainControl;
    F32ParameterListItem<PreviewEffectReverbStd> m_OutGainControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "ReverbStdParameterListView";
    }
#endif
};

} // snd
} // nw
