﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListView.h>
#include <controls/F32ParameterListItem.h>
#include <controls/SelectableParameterListItem.h>
#include <models/PreviewEffect.h>

namespace nw {
namespace snd {

class ReverbHiParameterListView : public ParameterListView<PreviewEffectReverbHi, 16>
{
public:
    ReverbHiParameterListView();

protected:
    //! @brief UI要素サイズ計算の準備を行います。
    /* override */ void OnPrepareMeasure();

private:
    SelectableParameterListItem<PreviewEffectReverbHi, FxReverbEarlyReflectionMode> m_EaryReflectionModeControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_PreDelayTimeMaxControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_PreDelayTimeControl;
    SelectableParameterListItem<PreviewEffectReverbHi, FxReverbFusedMode> m_FusedModeControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_FusedTimeControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_ColorationControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_DampingControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_CrosstalkControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_EarlyGainControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_FusedGainControl;
    F32ParameterListItem<PreviewEffectReverbHi> m_OutGainControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "ReverbHiParameterListView";
    }
#endif
};

} // snd
} // nw
