﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <controls/ParameterListView.h>

namespace nw {
namespace snd {

template<class TModel, u32 MaxItemCount>
const f32 ParameterListView<TModel, MaxItemCount>::INVALID_WIDTH = -1.f;

template<class TModel, u32 MaxItemCount>
ParameterListView<TModel, MaxItemCount>::ParameterListView() :
m_pModel(NULL),
m_LabelWidth(INVALID_WIDTH)
{
    SetMargin(nw::internal::dw::Thickness(0.f));

    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);
}

template<class TModel, u32 MaxItemCount>
void ParameterListView<TModel, MaxItemCount>::SetModel(TModel* pModel)
{
    if(m_pModel == pModel)
    {
        return;
    }

    m_pModel = pModel;

    if(m_pModel == NULL)
    {
        return;
    }

    UpdateModels();

    // ラストフォーカスまたは最初の項目を選択します。
    if(m_Container.GetItemCount() > 0)
    {
        s32 index = m_Container.GetFocusedItemIndex();

        if(index < 0)
        {
            index = 0;
        }

        m_Container.GetItemPlaceHolder(index).SetIsSelected(true);
    }
}

template<class TModel, u32 MaxItemCount>
void ParameterListView<TModel, MaxItemCount>::SetLabelWidth(f32 width)
{
    for(s32 i = 0; i < m_Container.GetItemCount(); ++i)
    {
        m_ListItems[i]->SetLabelWidth(width);
    }
}

template<class TModel, u32 MaxItemCount>
void ParameterListView<TModel, MaxItemCount>::AddItem(ModelParameterListItem<TModel>& item)
{
    u32 index = m_Container.GetItemCount();
    NW_ASSERT(index < MaxItemCount);

    m_ListItems[index] = &item;
    m_Container.AddItem(&item);

    item.SetLabelWidth(m_LabelWidth);

    if(m_pModel != NULL)
    {
        item.SetModel(m_pModel);
        item.ResetValue();
    }
}

template<class TModel, u32 MaxItemCount>
void ParameterListView<TModel, MaxItemCount>::UpdateModels()
{
    NW_NULL_ASSERT(m_pModel);

    for(s32 i = 0; i < m_Container.GetItemCount(); ++i)
    {
        m_ListItems[i]->SetModel(m_pModel);
    }
}

} // snd
} // nw
