﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>
#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief  チャンクヘッダ
//---------------------------------------------------------------------------
typedef struct ChunkHeader
{
    /* ctor */ ChunkHeader() :
        id(0),
        size(0)
    { }

    /* ctor */ ChunkHeader(u32 id) :
        id(id),
        size(0)
    { }

    /* ctor */ ChunkHeader(u32 id, u32 size) :
        id(id),
        size(size)
    { }

    //---------------------------------------------------------------------------

    u32      id;
    internal::fnd::PcBinU32 size;
} ChunkHeader;

//---------------------------------------------------------------------------
//! @brief  チャンクヘッダ（ビッグエンディアン版）
//---------------------------------------------------------------------------
typedef struct BigEndianChunkHeader
{
    /* ctor */ BigEndianChunkHeader() :
        id(0),
        size(0)
    { }

    /* ctor */ BigEndianChunkHeader(u32 id) :
        id(id),
        size(0)
    { }

    /* ctor */ BigEndianChunkHeader(u32 id, u32 size) :
        id(id),
        size(size)
    { }

    //---------------------------------------------------------------------------

    u32    id;
    internal::fnd::BinU32 size;
} BigEndianChunkHeader;

} // snd
} // nw
