﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// キャッシュ対応で使用する、リングバッファ
#pragma once

#include <nw/ut.h>

namespace nw {
namespace snd {

template <typename TClass, u32 num>
class RingBuffer
{
public:
    RingBuffer()
        : m_Index(0)
    {
        Clear();
    }

    ~RingBuffer()
    {
    }

    TClass* operator[](int idx)
    {
        NW_MINMAX_ASSERT(idx, 0, num);
        return m_Buffer[idx];
    }

    TClass* Push(TClass* item)
    {
        // 追加したときに溢れるアイテムのポインタを返します。
        // delete/freeなどは呼ばれません。
        m_Buffer[m_Index] = item;
        m_Index = (++m_Index) % num;
        TClass* ret = m_Buffer[m_Index];
        m_Buffer[m_Index] = NULL;
        return ret;
    }

    u32 Size() const { return num; }

    void Clear()
    {
        for (int i=0; i<num; ++i)
        {
            m_Buffer[i] = NULL;
        }
        m_Index = 0;
    }

private:
    TClass* m_Buffer[num];
    u32 m_Index;
};

} // namespace snd
} // namespace nw

//eof
