﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace snd {

class IAnimSoundTarget
{
public:
    virtual void Destroy() = 0;

    virtual u32 OnLoadModel(const char* filePath, bool isReload) = 0;
    virtual u32 OnLoadAnimation(const char* filePath, bool isReload) = 0;
    virtual void OnUnload() = 0;
    virtual void OnUpdateInputs(const dev::Pad* pad, const nw::dev::Mouse* mouse) = 0;
    virtual void OnCalc() = 0;
    virtual void OnDraw() = 0;

    virtual void OnPlayAnim() = 0;
    virtual void OnStopAnim() = 0;
    virtual void OnSetLoop(bool flg) = 0;
    virtual void OnSetRange(f32 start, f32 end) = 0;
    virtual f32  OnGetRangeStart() = 0;
    virtual f32  OnGetRangeEnd() = 0;
    virtual void OnSetRate(f32 rate) = 0;
    virtual f32  OnGetRate() = 0;
    virtual void OnSetFrame(f32 frame) = 0;
    virtual f32  OnGetFrame() = 0;

    virtual bool IsPlayingAnim() = 0;
    virtual void SetCameraEnabled(bool enabled) = 0;
};

} // namespace snd
} // namespace nw

// eof
