﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>

namespace nw {
namespace snd {

class IAnimSoundTarget;

// todo?
// シングルトンにする必要はないかも
class GfxCoordinator
{
public:
    //! @brief Initialize に渡す生成パラメータです。
    struct InitializeArg
    {
        nw::ut::IAllocator* allocator;            //!< アロケータです。
        u8*                 shaderBinary;         //!< シェーダーバイナリへのポインタです。
        u32                 shaderBinarySize;     //!< シェーダーバイナリのサイズです。
        u8*                 fontBinary;           //!< フォントバイナリへのポインタです。
        u32                 fontBinarySize;       //!< フォントバイナリのサイズです。
        s32                 screenWidth;          //!< スクリーンの幅です。
        s32                 screenHeight;         //!< スクリーンの高さです。

        //! @brief コンストラクタです。
        InitializeArg() :
            allocator( NULL ),
            shaderBinary( NULL ),
            shaderBinarySize( 0 ),
            fontBinary( NULL ),
            fontBinarySize( 0 )
        {}
    };

public:
    static void Initialize(const InitializeArg& arg);
    static void Finalize();
    static bool IsInitialized() { return s_InitializeArg.allocator != NULL; }

    static GfxCoordinator& GetInstance();

    u32 LoadModel(const char* filePath, bool isReload);
    u32 LoadAnimation(const char* filePath, bool isReload);
    void Unload();
    void UpdateInputs(const dev::Pad* pad, const nw::dev::Mouse* mouse);
    void Calc();
    void Draw();

    void PlayAnim();
    void StopAnim();
    bool IsPlayingAnim();
    void SetLoop(bool flg);
    void SetRange(f32 start, f32 end);
    f32  GetRangeStart();
    f32  GetRangeEnd();
    void SetRate(f32 rate);
    f32  GetRate();
    void SetFrame(f32 frame);
    f32  GetFrame();

    void SetCameraEnabled(bool isCameraEnabled);

private:
    GfxCoordinator();
    ~GfxCoordinator();

private:
    static InitializeArg s_InitializeArg;

    IAnimSoundTarget* m_Target;
};

} // namespace snd
} // namespace nw

// eof
