﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using NintendoWare.SoundFoundation.Projects;
    using Runtime = NintendoWare.SoundRuntime;

    public static class PanCurveEx
    {
        public static Runtime.PanCurve ToRuntimePanCurve(this PanCurve value)
        {
            switch (value)
            {
                case PanCurve.Linear:
                    return Runtime.PanCurve.PAN_LAW_LINEAR;

                case PanCurve.Linear_0Db:
                    return Runtime.PanCurve.PAN_LAW_LINEAR_0DB;

                case PanCurve.Linear_0Db_Clamp:
                    return Runtime.PanCurve.PAN_LAW_LINEAR_0DB_CLAMP;

                case PanCurve.SinCos:
                    return Runtime.PanCurve.PAN_LAW_SINCOS;

                case PanCurve.SinCos_0Db:
                    return Runtime.PanCurve.PAN_LAW_SINCOS_0DB;

                case PanCurve.SinCos_0Db_Clamp:
                    return Runtime.PanCurve.PAN_LAW_SINCOS_0DB_CLAMP;

                case PanCurve.Sqrt:
                    return Runtime.PanCurve.PAN_LAW_SQRT;

                case PanCurve.Sqrt_0Db:
                    return Runtime.PanCurve.PAN_LAW_SQRT_0DB;

                case PanCurve.Sqrt_0Db_Clamp:
                    return Runtime.PanCurve.PAN_LAW_SQRT_0DB_CLAMP;
            }

            throw new ArgumentException("invalid pan curve.");
        }
    }
}
