﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundationGeneric.Resources
{
    using System.IO;
    using System.Text;

    internal class FileResourceCtrProxy
    {
        internal static string SoundArchiveBinaryMap
        {
            get { return GetUtf8String("SoundArchiveBinaryMap"); }
        }

        private static string GetUtf8String(string resourceName)
        {
            using (var reader = new StreamReader(
                new MemoryStream((byte[])FileResourceCtr.ResourceManager.GetObject(resourceName, FileResourceCtr.Culture)),
                Encoding.UTF8))
            {
                return reader.ReadToEnd();
            }
        }
    }
}
