﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// Nintendo.Sound.Nw.h

#pragma once

namespace NintendoWare { namespace SoundRuntime {

using namespace System;
using namespace System::Runtime::InteropServices;

public ref class Global
{
  public:
    static const int ChannelCount = nn::atk::SoundSystem::GetRendererChannelCountMax();
    static const int MsecPerFrame = nn::atk::detail::driver::HardwareManager::SoundFrameIntervalMsec;
    static const int DefaultSampleRate = nn::atk::detail::driver::HardwareManager::DefaultRendererSampleRate;

    static int AXSynthesize( array<short>^ buffer, int samplingRate );
};

public ref class AtkSoundSystem
{
public:
    static void InitSoundSystem(int soundThreadPriority, int dvdThreadPriority);
    static void ShutdownSoundSystem();

    static int GetActiveVoiceCount();

    static void StopAllVoices();

    static void LockSoundThread();
    static void UnlockSoundThread();

    static void SoundFrameProcess();

    static void SoundThreadPause( bool pauseFlag );
};


}}
