﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml;
using System.IO;
using System.Collections;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{
    /// <summary>
    /// Nw4rXmlCharaAnim の概要の説明です。
    /// </summary>
    public class Nw4rXmlCharaAnim
    {
        int frameSize;
        string createUser;
        string createHost;
        string createDate;

        public int FrameSize
        {
            get { return frameSize; }
        }
        public string CreateUser
        {
            get { return createUser; }
        }
        public string CreateHost
        {
            get { return createHost; }
        }
        public string CreateDate
        {
            get { return createDate; }
        }

        public void Load(string filePath)
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(filePath);

            XmlNamespaceManager nsmgr = new XmlNamespaceManager(doc.NameTable);
            nsmgr.AddNamespace("a", "http://www.nintendo.co.jp/NW4R/3DIntermediateFileFormat");

            XmlElement root = doc.DocumentElement;
            if (root.Name != "nw4r_3dif")
            {
                throw new Nw4rFileFormatException("Unexpcted file format \"" + filePath + "\"");
            }

            XmlElement headElem = (XmlElement)root.SelectSingleNode("a:head", nsmgr);
            if (headElem != null)
            {
                XmlElement createElem = (XmlElement)headElem.SelectSingleNode("a:create", nsmgr);
                if (createElem != null)
                {
                    if (createElem.HasAttribute("user"))
                    {
                        createUser = createElem.GetAttribute("user");
                    }
                    if (createElem.HasAttribute("host"))
                    {
                        createHost = createElem.GetAttribute("host");
                    }
                    if (createElem.HasAttribute("date"))
                    {
                        createDate = createElem.GetAttribute("date");
                    }
                }
            }

            XmlElement bodyElem = (XmlElement)root.SelectSingleNode("a:body", nsmgr);
            if (bodyElem != null)
            {
                XmlElement rchaElem = (XmlElement)bodyElem.SelectSingleNode("a:rcha", nsmgr);
                if (rchaElem != null)
                {
                    XmlElement nodeAnimInfoElem = (XmlElement)rchaElem.SelectSingleNode("a:node_anim_info", nsmgr);
                    if (nodeAnimInfoElem != null)
                    {
                        if (nodeAnimInfoElem.HasAttribute("frame_size"))
                        {
                            frameSize = Int32.Parse(nodeAnimInfoElem.GetAttribute("frame_size"));
                        }
                    }
                }
            }
        }
    }

}

