﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml;
using System.IO;
using System.Collections;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{
    /// <summary>
    /// Nw4rAnimSoundMakerProject の概要の説明です。
    /// </summary>
    public class Nw4rAnimSoundMakerProject : Nw4rXmlFile
    {
        string soundArchiveFilePath;
        string binaryAnimSoundFilePath;
        bool isEnableBinaryAnimSoundFilePath = false;
        ModelCollection models = new ModelCollection();

        public class AnimSound
        {
            string path;

            public string FilePath
            {
                get { return path; }
                set { path = value; }
            }
        }

        public class AnimSoundCollection : IEnumerable
        {
            ArrayList itemList = new ArrayList();

            /******************************************************************************
               interface
             ******************************************************************************/
            IEnumerator IEnumerable.GetEnumerator()
            {
                return itemList.GetEnumerator();
            }

            /******************************************************************************
               public
             ******************************************************************************/
            public int Count
            {
                get { return itemList.Count; }
            }

            public void Clear()
            {
                itemList.Clear();
            }

            public void Add(AnimSound animSound)
            {
                itemList.Add(animSound);
            }
            public void Remove(AnimSound animSound)
            {
                itemList.Remove(animSound);
            }
        }

        public class Anim
        {
            string path;
            AnimSoundCollection animSounds = new AnimSoundCollection();

            public string FilePath
            {
                get { return path; }
                set { path = value; }
            }
            public AnimSoundCollection AnimSounds
            {
                get { return animSounds; }
                set { animSounds = value; }
            }
        }

        public class AnimCollection : IEnumerable
        {
            ArrayList itemList = new ArrayList();

            /******************************************************************************
               interface
             ******************************************************************************/
            IEnumerator IEnumerable.GetEnumerator()
            {
                return itemList.GetEnumerator();
            }

            /******************************************************************************
               public
             ******************************************************************************/
            public int Count
            {
                get { return itemList.Count; }
            }

            public void Clear()
            {
                itemList.Clear();
            }

            public void Add(Anim anim)
            {
                itemList.Add(anim);
            }
            public void Remove(Anim anim)
            {
                itemList.Remove(anim);
            }
        }

        public class Model
        {
            string path;
            AnimCollection anims = new AnimCollection();

            public string FilePath
            {
                get { return path; }
                set { path = value; }
            }
            public AnimCollection Anims
            {
                get { return anims; }
                set { anims = value; }
            }
        }

        public class ModelCollection : IEnumerable
        {
            ArrayList itemList = new ArrayList();

            /******************************************************************************
               interface
             ******************************************************************************/
            IEnumerator IEnumerable.GetEnumerator()
            {
                return itemList.GetEnumerator();
            }

            /******************************************************************************
               public
             ******************************************************************************/
            public int Count
            {
                get { return itemList.Count; }
            }

            public void Clear()
            {
                itemList.Clear();
            }

            public void Add(Model model)
            {
                itemList.Add(model);
            }
            public void Remove(Model model)
            {
                itemList.Remove(model);
            }
        }

        public ModelCollection Models
        {
            get { return models; }
            set { models = value; }
        }
        public string SoundArchiveFilePath
        {
            get { return soundArchiveFilePath; }
            set { soundArchiveFilePath = value; }
        }
        public string BinaryAnimSoundFilePath
        {
            get { return binaryAnimSoundFilePath; }
            set { binaryAnimSoundFilePath = value; }
        }
        public bool IsEnableBinaryAnimSoundFilePath
        {
            get { return isEnableBinaryAnimSoundFilePath; }
            set { isEnableBinaryAnimSoundFilePath = value; }
        }

        protected override string FileTitle { get { return "NintendoWare Animation Sound Project"; } }

        void LoadAnimSoundCollection(XmlDocument doc, XmlElement animElem, Anim anim)
        {
            XmlElement animSoundArrayElem = (XmlElement)animElem.SelectSingleNode("anim_sound_array");
            if (animSoundArrayElem != null)
            {
                foreach (XmlElement animSoundElem in animSoundArrayElem.SelectNodes("anim_sound"))
                {
                    AnimSound animSound = new AnimSound();

                    XmlElement fileElem = (XmlElement)animSoundElem.SelectSingleNode("file");
                    if (fileElem != null)
                    {
                        if (fileElem.HasAttribute("path"))
                        {
                            animSound.FilePath = fileElem.GetAttribute("path");
                            anim.AnimSounds.Add(animSound);
                        }
                    }
                }
            }
        }

        void LoadAnimCollection(XmlDocument doc, XmlElement modelElem, Model model)
        {
            XmlElement animArrayElem = (XmlElement)modelElem.SelectSingleNode("anim_array");
            if (animArrayElem != null)
            {
                foreach (XmlElement animElem in animArrayElem.SelectNodes("anim"))
                {
                    Anim anim = new Anim();

                    XmlElement fileElem = (XmlElement)animElem.SelectSingleNode("file");
                    if (fileElem != null)
                    {
                        if (fileElem.HasAttribute("path"))
                        {
                            anim.FilePath = fileElem.GetAttribute("path");
                            model.Anims.Add(anim);
                        }
                    }

                    LoadAnimSoundCollection(doc, animElem, anim);
                }
            }
        }

        protected override void LoadBody(XmlDocument doc, XmlElement bodyElem)
        {
            models.Clear();

            XmlElement animSoundProjectElem = (XmlElement)bodyElem.SelectSingleNode("anim_sound_project");
            if (animSoundProjectElem != null)
            {
                XmlElement soundArchiveElem = (XmlElement)animSoundProjectElem.SelectSingleNode("sound_archive");
                if (soundArchiveElem != null)
                {
                    XmlElement fileElem = (XmlElement)soundArchiveElem.SelectSingleNode("file");
                    if (fileElem != null)
                    {
                        if (fileElem.HasAttribute("path"))
                        {
                            soundArchiveFilePath = fileElem.GetAttribute("path");
                        }
                    }
                }

                XmlElement projectSettingElem = (XmlElement)animSoundProjectElem.SelectSingleNode("project_setting");
                if (projectSettingElem != null)
                {
                    XmlElement binaryAnimSoundFilePathElem = (XmlElement)projectSettingElem.SelectSingleNode("binary_anim_sound_file_path");
                    if (binaryAnimSoundFilePathElem != null)
                    {
                        binaryAnimSoundFilePath = binaryAnimSoundFilePathElem.InnerText;
                        isEnableBinaryAnimSoundFilePath = true;

                        if (binaryAnimSoundFilePathElem.HasAttribute("disable"))
                        {
                            isEnableBinaryAnimSoundFilePath = false;
                        }
                    }
                }

                XmlElement modelArrayElem = (XmlElement)animSoundProjectElem.SelectSingleNode("model_array");
                if (modelArrayElem != null)
                {
                    foreach (XmlElement modelElem in modelArrayElem.SelectNodes("model"))
                    {
                        Model model = new Model();

                        XmlElement fileElem = (XmlElement)modelElem.SelectSingleNode("file");
                        if (fileElem != null)
                        {
                            if (fileElem.HasAttribute("path"))
                            {
                                model.FilePath = fileElem.GetAttribute("path");
                                models.Add(model);
                            }
                        }

                        LoadAnimCollection(doc, modelElem, model);
                    }
                }
            }
        }

        void SaveAnimSoundCollection(XmlDocument doc, XmlElement animElem, AnimSoundCollection animSounds)
        {
            if (animSounds.Count > 0)
            {
                XmlElement animSoundArrayElem = doc.CreateElement("anim_sound_array");
                animElem.AppendChild(animSoundArrayElem);

                foreach (AnimSound animSound in animSounds)
                {
                    XmlElement animSoundElem = doc.CreateElement("anim_sound");
                    if (animSound.FilePath != null)
                    {
                        XmlElement fileElem = doc.CreateElement("file");
                        fileElem.SetAttribute("path", animSound.FilePath);
                        animSoundElem.AppendChild(fileElem);
                    }

                    animSoundArrayElem.AppendChild(animSoundElem);
                }
            }
        }

        void SaveAnimCollection(XmlDocument doc, XmlElement modelElem, AnimCollection anims)
        {
            if (anims.Count > 0)
            {
                XmlElement animArrayElem = doc.CreateElement("anim_array");
                modelElem.AppendChild(animArrayElem);

                foreach (Anim anim in anims)
                {
                    XmlElement animElem = doc.CreateElement("anim");
                    if (anim.FilePath != null)
                    {
                        XmlElement fileElem = doc.CreateElement("file");
                        fileElem.SetAttribute("path", anim.FilePath);
                        animElem.AppendChild(fileElem);
                    }

                    SaveAnimSoundCollection(doc, animElem, anim.AnimSounds);

                    animArrayElem.AppendChild(animElem);
                }
            }
        }

        protected override void SaveBody(XmlDocument doc, XmlElement bodyElem)
        {
            XmlElement animSoundProjectElem = doc.CreateElement("anim_sound_project");
            bodyElem.AppendChild(animSoundProjectElem);

            if (soundArchiveFilePath != null)
            {
                XmlElement soundArchiveElem = doc.CreateElement("sound_archive");
                animSoundProjectElem.AppendChild(soundArchiveElem);

                XmlElement fileElem = doc.CreateElement("file");
                fileElem.SetAttribute("path", soundArchiveFilePath);
                soundArchiveElem.AppendChild(fileElem);
            }

            {
                XmlElement projectSettingElem = doc.CreateElement("project_setting");
                animSoundProjectElem.AppendChild(projectSettingElem);

                if (binaryAnimSoundFilePath != null)
                {
                    XmlElement binaryAnimSoundFilePathElem = doc.CreateElement("binary_anim_sound_file_path");
                    if (!isEnableBinaryAnimSoundFilePath)
                    {
                        binaryAnimSoundFilePathElem.SetAttribute("disable", "true");
                    }
                    binaryAnimSoundFilePathElem.InnerText = binaryAnimSoundFilePath;
                    projectSettingElem.AppendChild(binaryAnimSoundFilePathElem);
                }
            }

            if (models.Count > 0)
            {
                XmlElement modelArrayElem = doc.CreateElement("model_array");
                animSoundProjectElem.AppendChild(modelArrayElem);

                foreach (Model model in models)
                {
                    XmlElement modelElem = doc.CreateElement("model");
                    if (model.FilePath != null)
                    {
                        XmlElement fileElem = doc.CreateElement("file");
                        fileElem.SetAttribute("path", model.FilePath);
                        modelElem.AppendChild(fileElem);
                    }

                    SaveAnimCollection(doc, modelElem, model.Anims);

                    modelArrayElem.AppendChild(modelElem);
                }
            }
        }
    }

}

