﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class StreamSoundTrackCtr : StreamSoundTrackBase
    {
        public override ICloneable Clone()
        {
            StreamSoundTrackBase track = new StreamSoundTrackCtr();

            track.FilePath = this.FilePath;
            track.Volume = this.Volume;
            track.Pan = this.Pan;
            track.SurroundPan = this.SurroundPan;
            track.FrontBypass = this.FrontBypass;
            track.Sends = this.Sends.Clone() as Sends;

            return track;
        }

        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            //
            StreamSoundSendsParameterValueCtr sendsParam =
                new StreamSoundSendsParameterValueCtr( new Sends());
            this.Parameters.RemoveValue( ProjectParameterNames.Sound.Sends);
            Parameters.AddValue( ProjectParameterNames.Sound.Sends, sendsParam);

            // sndedit 転送対象パラメータ
            this.SetParameterAttributes(ProjectParameterNames.Sound.Sends, ParameterAttributes.ComputeSndeditTransferHash);
        }
    }
}
