﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;

namespace NintendoWare.SoundProjectUtility
{
    /// <summary>
    /// <see cref="IResultWriter"/> の実装を提供します。
    /// </summary>
    internal class ResultWriter : IResultWriter
    {
        /// <summary>
        /// コンソールに出力します。
        /// </summary>
        public ResultWriter()
        {
            this.Out = Console.Out;
            this.Error = Console.Error;
        }

        /// <summary>
        /// <see cref="Out"/>  は指定のライターで出力し、<see cref="Error"/> はコンソールに出力します。
        /// </summary>
        /// <param name="outWriter"></param>
        public ResultWriter(TextWriter outWriter)
        {
            this.Out = outWriter;
            this.Error = Console.Error;
        }

        public TextWriter Error { get; }

        public TextWriter Out { get; }

        /// <summary>
        /// 出力用の <see cref="TextWriter"/> を作成します。
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        internal static TextWriter OpenOutputFile(string filePath)
        {
            return new StreamWriter(filePath);
        }
    }
}
